/*
 * Decompiled with CFR 0.152.
 */
package com.lodestar.aileron.mixin;

import com.lodestar.aileron.Aileron;
import com.lodestar.aileron.AileronConfig;
import com.lodestar.aileron.AileronEntityData;
import com.lodestar.aileron.AileronNetworking;
import com.lodestar.aileron.accessor.AileronPlayer;
import com.lodestar.aileron.client.AileronClient;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
implements AileronPlayer {
    int campfireDamageIFrames = 0;
    int smokeTrailTicks = 0;
    int chargeTime = 0;
    int airChargeTime = 0;
    boolean charged = false;
    int startFlyingTimer = 0;
    int boostTicks = 0;

    @Shadow
    public abstract boolean m_7578_();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void postTick(CallbackInfo ci) {
        ServerLevel serverLevel;
        Player self = (Player)this;
        Level level = self.m_9236_();
        if (this.boostTicks > 0) {
            --this.boostTicks;
        }
        if (!self.m_21255_()) {
            this.boostTicks = 0;
        }
        if (this.campfireDamageIFrames > 0) {
            --this.campfireDamageIFrames;
        }
        if (this.startFlyingTimer > 0) {
            --this.startFlyingTimer;
        }
        if (this.smokeTrailTicks > 0) {
            --this.smokeTrailTicks;
        }
        if (!self.m_21255_()) {
            this.smokeTrailTicks = 0;
        }
        if (this.boostTicks > 0) {
            if (level.f_46443_ && this.m_7578_()) {
                Vec3 vec31 = self.m_20154_();
                Vec3 vec32 = self.m_20184_();
                self.m_20256_(vec32.m_82520_(vec31.f_82479_ * 0.1 + (vec31.f_82479_ * 1.5 - vec32.f_82479_) * 0.5, vec31.f_82480_ * 0.1 + (vec31.f_82480_ * 1.5 - vec32.f_82480_) * 0.5, vec31.f_82481_ * 0.1 + (vec31.f_82481_ * 1.5 - vec32.f_82481_) * 0.5));
            } else if (self.f_19797_ % 3 == 0) {
                serverLevel = (ServerLevel)level;
                for (ServerPlayer player : serverLevel.m_6907_()) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, false, self.m_20185_(), self.m_20186_(), self.m_20189_(), 2, 0.2, 0.2, 0.2, 0.1);
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123755_, false, self.m_20185_(), self.m_20186_(), self.m_20189_(), 3, 0.2, 0.2, 0.2, 0.1);
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123777_, false, self.m_20185_(), self.m_20186_(), self.m_20189_(), 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        if (this.smokeTrailTicks > 0 && self.f_19797_ % 3 == 0) {
            serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                SimpleParticleType[] pos = self.m_20182_().m_82549_(self.m_20154_().m_82490_(-1.0));
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123778_, false, pos.f_82479_, pos.f_82480_, pos.f_82481_, 2, 0.1, 0.1, 0.1, 0.005);
            }
        }
        BlockState underBlockState = level.m_8055_(self.m_20183_());
        if (self.m_6047_() && underBlockState.m_204336_(BlockTags.f_13087_) && Aileron.canChargeSmokeStack(self)) {
            if (level.f_46443_) {
                SimpleParticleType[] particles;
                boolean isSoul = underBlockState.m_60713_(Blocks.f_50684_);
                for (SimpleParticleType particle : particles = new SimpleParticleType[]{isSoul ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_, ParticleTypes.f_123762_}) {
                    Vec3 randomOffset = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
                    randomOffset = randomOffset.m_82541_().m_82490_(2.0);
                    BlockPos[] motion = randomOffset.m_82490_(-0.075);
                    Vec3 position = self.m_20182_().m_82520_(0.0, (double)self.m_20192_() / 2.0, 0.0).m_82549_(randomOffset);
                    level.m_7106_((ParticleOptions)particle, position.f_82479_, position.f_82480_, position.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            } else {
                ServerLevel serverLevel2 = (ServerLevel)level;
                ++this.chargeTime;
                if (this.chargeTime % AileronConfig.smokestackChargeTicks() == 0 && this.chargeTime > 0) {
                    this.smokeCharge(true);
                }
            }
        } else {
            this.chargeTime = 0;
            if (!(level.f_46443_ || self.m_21255_() || this.campfireDamageIFrames != 0 || this.charged)) {
                self.m_20088_().m_135381_(AileronEntityData.SMOKE_STACK_CHARGES, (Object)0);
            }
        }
        if (this.startFlyingTimer == 0 && !level.f_46443_) {
            this.startFlyingTimer = -1;
            self.m_36320_();
        }
        if (!self.m_6047_() && this.charged) {
            ServerLevel serverLevel3 = (ServerLevel)level;
            this.charged = false;
            this.chargeTime = 0;
            Aileron.sendBoostParticles(serverLevel3, self.m_20185_(), self.m_20186_(), self.m_20189_());
            this.setCampfireDamageIFrames(20);
            level.m_5594_(null, self.m_20183_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.8f, 0.8f);
            self.m_36320_();
            AileronNetworking.sendSmokeStackLaunch((ServerPlayer)self);
            self.m_36319_();
            this.startFlyingTimer = 5;
        }
        if (self.m_21255_()) {
            boolean isLit;
            int maxRange = 38;
            int depth = 0;
            BlockPos blockPosition = self.m_20183_();
            while (depth < maxRange && level.m_46859_(blockPosition) && level.m_46739_(blockPosition)) {
                ++depth;
                blockPosition = blockPosition.m_7495_();
            }
            BlockState blockState = level.m_8055_(blockPosition);
            if (blockState.m_204336_(BlockTags.f_13087_) && (isLit = ((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue())) {
                BlockPos[] possibleNeighbors = new BlockPos[]{blockPosition.m_122012_(), blockPosition.m_122019_(), blockPosition.m_122029_(), blockPosition.m_122024_()};
                int neighbors = 0;
                for (BlockPos neighbor : possibleNeighbors) {
                    if (!(level.m_8055_(neighbor).m_60734_() instanceof CampfireBlock)) continue;
                    ++neighbors;
                }
                boolean isExtendedRange = (Boolean)blockState.m_61143_((Property)CampfireBlock.f_51228_);
                float maxStrength = AileronConfig.campfirePushMaxStrength();
                float minStrength = AileronConfig.campfirePushBaseStrength();
                float rangePerNeighbor = (maxStrength - minStrength) / 4.0f;
                int range = (int)(isExtendedRange ? maxStrength : minStrength + rangePerNeighbor * (float)neighbors);
                double distance = Math.abs((double)blockPosition.m_123342_() - self.m_20182_().f_82480_);
                if (distance < (double)range) {
                    if (self.m_9236_().f_46443_) {
                        if (AileronConfig.campfiresPushPlayers() && self.m_7578_()) {
                            double force = Math.min((double)range / distance / 7.0, 1.0);
                            Vec3 existingDeltaMovement = self.m_20184_();
                            self.m_20334_(existingDeltaMovement.f_82479_, Math.min(existingDeltaMovement.f_82480_ + force, 1.0), existingDeltaMovement.f_82481_);
                        }
                    } else if (AileronConfig.smokestackAirRecharge()) {
                        ++this.airChargeTime;
                        if (this.airChargeTime >= AileronConfig.smokestackChargeTicks()) {
                            this.airChargeTime = 0;
                            this.smokeCharge(false);
                        }
                    }
                }
            }
        } else {
            this.airChargeTime = 0;
        }
        if (self.m_9236_().f_46443_ && self.m_7578_()) {
            AileronClient.localPlayerTick(self);
        }
    }

    @Unique
    public void smokeCharge(boolean shouldSetCharged) {
        shouldSetCharged = AileronConfig.campfiresPushPlayers() && shouldSetCharged;
        Player self = (Player)this;
        Level level = self.m_9236_();
        ServerLevel serverLevel = (ServerLevel)level;
        int stocks = (Integer)self.m_20088_().m_135370_(AileronEntityData.SMOKE_STACK_CHARGES);
        int smokeStockMaxLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation("aileron", "smokestack"))), (ItemStack)Aileron.getElytra((LivingEntity)self));
        boolean chargeEffect = false;
        if (shouldSetCharged && !this.charged) {
            chargeEffect = true;
            this.charged = true;
        }
        if (stocks < smokeStockMaxLevel) {
            chargeEffect = true;
            self.m_20088_().m_135381_(AileronEntityData.SMOKE_STACK_CHARGES, (Object)(stocks + 1));
        }
        if (chargeEffect) {
            for (ServerPlayer player : serverLevel.m_6907_()) {
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123755_, false, self.m_20185_(), self.m_20186_(), self.m_20189_(), 20, 0.5, 0.5, 0.5, 0.1);
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, false, self.m_20185_(), self.m_20186_(), self.m_20189_(), 100, 0.5, 0.5, 0.5, 0.4);
            }
            level.m_5594_(null, self.m_20183_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.8f, 0.8f + (float)stocks * 0.2f);
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void defineSynchedData(CallbackInfo ci) {
        ((Player)this).m_20088_().m_135372_(AileronEntityData.SMOKE_STACK_CHARGES, (Object)0);
    }

    @Override
    public boolean charged() {
        return this.charged;
    }

    @Override
    public int getBoostTicks() {
        return this.boostTicks;
    }

    @Override
    public void setBoostTicks(int boostTicks) {
        this.boostTicks = boostTicks;
    }

    @Override
    public void setSmokeTrailTicks(int boostTicks) {
        this.smokeTrailTicks = boostTicks;
    }

    @Override
    public int getCampfireDamageIFrames() {
        return this.campfireDamageIFrames;
    }

    @Override
    public void setCampfireDamageIFrames(int campfireDamageIFrames) {
        this.campfireDamageIFrames = campfireDamageIFrames;
    }
}

