/*
 * Decompiled with CFR 0.152.
 */
package com.lodestar.aileron.forge;

import com.lodestar.aileron.Aileron;
import com.lodestar.aileron.AileronEntityData;
import com.lodestar.aileron.client.AileronClient;
import com.lodestar.aileron.forge.loot.AileronLootModifiers;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod(value="aileron")
public class AileronImpl {
    public static final EnchantmentCategory ELYTRA_ENCHANTMENT_CATEGORY = EnchantmentCategory.create((String)"elytra", item -> Aileron.isElytra(item.m_7968_()));

    public AileronImpl() {
        Aileron.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> AileronClient::init);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AileronLootModifiers.register(modEventBus);
    }

    public static ItemStack getAccessoryElytra(LivingEntity entity) {
        Optional optional;
        if (Aileron.isModInstalled("curios") && (optional = CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios)).isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!Aileron.isElytra(stack) || stack.m_41776_() - stack.m_41773_() <= 0) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean canChargeSmokeStack(@Nullable Player player) {
        return player != null && Aileron.getElytra((LivingEntity)player).canElytraFly((LivingEntity)player) && ((Integer)player.m_20088_().m_135370_(AileronEntityData.SMOKE_STACK_CHARGES) > 0 && player.m_21255_() || player.m_6047_());
    }

    public static boolean isModInstalled(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static EnchantmentCategory getElytraEnchantmentCategory() {
        return ELYTRA_ENCHANTMENT_CATEGORY;
    }
}

