/*
 * Decompiled with CFR 0.152.
 */
package com.lodestar.aileron;

import com.lodestar.aileron.Aileron;
import com.lodestar.aileron.AileronEntityData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class AileronGuiRender {
    private static final ResourceLocation TEXTURE_EMPTY = new ResourceLocation("aileron:textures/gui/sprites/hud/smokestack_empty.png");
    private static final ResourceLocation TEXTURE_FULL = new ResourceLocation("aileron:textures/gui/sprites/hud/smokestack_full.png");

    public static int moveAttackIndicator() {
        int spriteX = 0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return spriteX;
        }
        if (!Aileron.canChargeSmokeStack((Player)player)) {
            return spriteX;
        }
        spriteX = player.m_5737_() == HumanoidArm.LEFT ? (spriteX -= 9) : (spriteX += 5);
        return spriteX;
    }

    public static void renderSmokeStackBar(GuiGraphics graphics, int screenHeight, int screenWidth) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!Aileron.canChargeSmokeStack((Player)player)) {
            return;
        }
        int smokeStockLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation("aileron", "smokestack"))), (ItemStack)Aileron.getElytra((LivingEntity)player));
        int screenX = screenWidth / 2;
        screenX = player.m_5737_() == HumanoidArm.LEFT ? (screenX -= 102) : (screenX += 92);
        int screenY = screenHeight - 10;
        int smokeStackCharges = (Integer)player.m_20088_().m_135370_(AileronEntityData.SMOKE_STACK_CHARGES);
        for (int spriteIndex = 0; spriteIndex < smokeStockLevel; ++spriteIndex) {
            ResourceLocation texture = smokeStackCharges > spriteIndex ? TEXTURE_FULL : TEXTURE_EMPTY;
            int spriteY = screenY - spriteIndex * 9;
            graphics.m_280163_(texture, screenX, spriteY, 0.0f, 0.0f, 9, 9, 9, 9);
        }
    }
}

