/*
 * Decompiled with CFR 0.152.
 */
package com.lodestar.aileron;

import com.lodestar.aileron.AileronConfig;
import com.lodestar.aileron.AileronEnchantments;
import com.lodestar.aileron.AileronEntityData;
import com.lodestar.aileron.AileronNetworking;
import com.lodestar.aileron.AileronParticles;
import com.lodestar.aileron.AileronTags;
import com.lodestar.aileron.accessor.AileronPlayer;
import com.lodestar.aileron.forge.AileronImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.jetbrains.annotations.Nullable;

public class Aileron {
    public static final String MOD_ID = "aileron";

    public static void init() {
        AileronConfig.init();
        AileronParticles.register();
        AileronEnchantments.register();
        AileronNetworking.register();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModInstalled(String modId) {
        return AileronImpl.isModInstalled(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canChargeSmokeStack(@Nullable Player player) {
        return AileronImpl.canChargeSmokeStack(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemStack getAccessoryElytra(LivingEntity entity) {
        return AileronImpl.getAccessoryElytra(entity);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnchantmentCategory getElytraEnchantmentCategory() {
        return AileronImpl.getElytraEnchantmentCategory();
    }

    public static boolean isElytra(ItemStack stack) {
        return stack.m_204117_(AileronTags.ELYTRA);
    }

    public static ItemStack getElytra(LivingEntity entity) {
        ItemStack stack = Aileron.getAccessoryElytra(entity);
        if (stack.m_41619_()) {
            ItemStack chestItem = entity.m_6844_(EquipmentSlot.CHEST);
            stack = Aileron.isElytra(chestItem) ? chestItem : ItemStack.f_41583_;
        }
        return stack;
    }

    public static void boostPlayer(Player player) {
        if (player instanceof AileronPlayer) {
            AileronPlayer ap = (AileronPlayer)player;
            ap.setBoostTicks(50);
        }
    }

    public static void playerDashedServer(ServerPlayer player) {
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        int stocks = (Integer)player.m_20088_().m_135370_(AileronEntityData.SMOKE_STACK_CHARGES);
        if (stocks > 0) {
            player.m_20088_().m_135381_(AileronEntityData.SMOKE_STACK_CHARGES, (Object)(stocks - 1));
            Aileron.sendBoostParticles(serverLevel, player.m_20185_(), player.m_20186_(), player.m_20189_());
            serverLevel.m_5594_(null, player.m_20183_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.8f, 0.8f + (float)stocks * 0.2f);
            Aileron.boostPlayer((Player)player);
        }
    }

    public static void sendBoostParticles(ServerLevel serverLevel, double x, double y, double z) {
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            serverLevel.m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123755_, false, x, y, z, 40, 0.5, 0.5, 0.5, 0.1);
            serverLevel.m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123777_, false, x, y, z, 40, 0.5, 0.5, 0.5, 0.1);
            serverLevel.m_8624_(serverPlayer, (ParticleOptions)ParticleTypes.f_123762_, false, x, y, z, 120, 0.5, 0.5, 0.5, 0.4);
        }
    }
}

