/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class SycamoreFoliagePlacer
extends FoliagePlacer {
    public static final Codec<SycamoreFoliagePlacer> CODEC = RecordCodecBuilder.create(sycamoreFoliagePlacerInstance -> SycamoreFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)sycamoreFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)sycamoreFoliagePlacerInstance, SycamoreFoliagePlacer::new));
    private final int height;

    public SycamoreFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.SYCAMORE_FOLIAGE_PLACER.get();
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected void m_213633_(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        BlockPos nextPos = pAttachment.m_161451_().m_7494_();
        if (pAttachment.m_68590_()) {
            for (int i = 0; i < this.height; ++i) {
                if (i <= 1) {
                    this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, nextPos, 2, -i, true);
                }
                if (i <= 3) {
                    this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, nextPos, 3, -i, true);
                }
                if (i > 5) continue;
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, nextPos, 1, -i, true);
            }
        } else {
            for (int j = 0; j < 3; ++j) {
                this.m_225628_(pLevel, pBlockSetter, pRandom, pConfig, nextPos, 1, -j, false);
            }
        }
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        if (pLarge) {
            double distance = Math.sqrt(Math.pow(pLocalX, 2.0) + Math.pow(pLocalZ, 2.0));
            if (pLocalY == 0) {
                return distance > 2.0;
            }
            if (pLocalY == -1) {
                return pLocalX > 2 || (double)pLocalZ > 2.0 + (double)((float)pRandom.m_216339_(0, 40) / 100.0f);
            }
            if (pLocalY >= -3) {
                return distance > (double)(3.0f + (float)pRandom.m_216339_(-20, 50) / 100.0f);
            }
            if (-pLocalY == this.height - 1) {
                return (double)pRandom.m_188501_() < 0.7;
            }
        } else {
            if (pLocalY == 0) {
                return pLocalX == pLocalZ && pLocalX == pRange;
            }
            if (pLocalY == -2) {
                return pRandom.m_188499_();
            }
        }
        return false;
    }
}

