/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapleTrunkPlacer
extends TrunkPlacer {
    public static final Codec<MapleTrunkPlacer> CODEC = RecordCodecBuilder.create(mapleTrunkPlacerInstance -> MapleTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)mapleTrunkPlacerInstance).apply((Applicative)mapleTrunkPlacerInstance, MapleTrunkPlacer::new));
    private static final Logger log = LoggerFactory.getLogger(MapleTrunkPlacer.class);

    public MapleTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.MAPLE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        MapleTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_(), (TreeConfiguration)pConfig);
        List<Direction> directions = List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = this.f_70263_ + pRandom.m_216339_(this.f_70264_, this.f_70265_ + 1);
        int stumpHeight = pRandom.m_216339_(2, 3);
        int branchHeight1 = pRandom.m_216339_(2, 5);
        int branchHeight2 = branchHeight1 + pRandom.m_216339_(1, 3);
        int branchHeight3 = branchHeight2 + pRandom.m_216339_(2, 4);
        int tempHeight = branchHeight1;
        int roots = 2;
        if (pRandom.m_188499_()) {
            ++roots;
        }
        for (int r = 0; r < roots; ++r) {
            Direction cardinal = directions.get(pRandom.m_216339_(0, 4));
            int amount = pRandom.m_216332_(-1, 1);
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_121945_(cardinal).m_5484_(cardinal.m_122427_(), amount), pConfig);
        }
        for (int s = 0; s < stumpHeight; ++s) {
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_6630_(s), pConfig);
        }
        pPos = pPos.m_6630_(stumpHeight - 1);
        for (int i = 1; i <= maxHeight; ++i) {
            BlockState log;
            int j;
            int branchLength;
            this.m_226187_(pLevel, pBlockSetter, pRandom, pPos.m_6630_(i), pConfig);
            if (i == tempHeight) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.m_6630_(branchHeight1 - 2), 0, false));
                branchLength = 4;
                for (Direction direction : directions) {
                    tempHeight = branchHeight1;
                    if (pRandom.m_188501_() < 0.25f) {
                        --branchLength;
                    }
                    for (j = 1; !(j > branchLength || j == 1 && (double)pRandom.m_188501_() < 0.1); ++j) {
                        if (j == branchLength) {
                            ++tempHeight;
                        }
                        log = (BlockState)pConfig.f_68185_.m_213972_(pRandom, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
                        pBlockSetter.accept(pPos.m_6630_(tempHeight).m_5484_(direction, j), (BlockState)Function.identity().apply(log));
                    }
                }
            }
            if (i + 1 == branchHeight2) {
                branchLength = pRandom.m_216339_(2, 4);
                for (Direction direction : directions) {
                    tempHeight = branchHeight2;
                    if (pRandom.m_188501_() < 0.25f) {
                        --branchLength;
                    }
                    for (j = 1; !(j > branchLength || j == 1 && (double)pRandom.m_188501_() < 0.1); ++j) {
                        if (j == branchLength) {
                            ++tempHeight;
                        }
                        log = (BlockState)pConfig.f_68185_.m_213972_(pRandom, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
                        pBlockSetter.accept(pPos.m_6630_(tempHeight).m_5484_(direction, j), (BlockState)Function.identity().apply(log));
                    }
                }
            }
            if (i + 1 != branchHeight3) continue;
            branchLength = 1;
            for (Direction direction : directions) {
                tempHeight = branchHeight3;
                for (j = 1; !(j > branchLength || j == 1 && (double)pRandom.m_188501_() < 0.1); ++j) {
                    if (j == branchLength) {
                        ++tempHeight;
                    }
                    log = (BlockState)pConfig.f_68185_.m_213972_(pRandom, pPos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
                    pBlockSetter.accept(pPos.m_6630_(tempHeight).m_5484_(direction, j), (BlockState)Function.identity().apply(log));
                }
            }
        }
        return foliageAttachments;
    }
}

