/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockBedBlock;

public class MushroomBedBlock
extends MultiblockBedBlock {
    private static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_N_1 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0));
    private static final VoxelShape SHAPE_S_1 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0));
    private static final VoxelShape SHAPE_E_1 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0));
    private static final VoxelShape SHAPE_W_1 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0));
    private static final VoxelShape SHAPE_N_2 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0));
    private static final VoxelShape SHAPE_S_2 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)17.0, (double)16.0));
    private static final VoxelShape SHAPE_E_2 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)16.0));
    private static final VoxelShape SHAPE_W_2 = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)17.0, (double)16.0));
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1, 2}}};

    public MushroomBedBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if ((Integer)pState.m_61143_((Property)MULTIBLOCK_PART) == 1) {
            return switch (facing) {
                case Direction.SOUTH -> SHAPE_S_1;
                case Direction.EAST -> SHAPE_E_1;
                case Direction.WEST -> SHAPE_W_1;
                default -> SHAPE_N_1;
            };
        }
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_S_2;
            case Direction.EAST -> SHAPE_E_2;
            case Direction.WEST -> SHAPE_W_2;
            default -> SHAPE_N_2;
        };
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.CONSUME;
        }
        int part = (Integer)pState.m_61143_((Property)MULTIBLOCK_PART);
        if (part == 1 && !(pState = pLevel.m_8055_(pPos = pPos.m_121945_((Direction)pState.m_61143_((Property)FACING)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!MushroomBedBlock.canSetSpawn(pLevel)) {
            pLevel.m_7471_(pPos, false);
            BlockPos removePos = pPos.m_121945_(((Direction)pState.m_61143_((Property)FACING)).m_122424_());
            if (pLevel.m_8055_(removePos).m_60713_((Block)this)) {
                pLevel.m_7471_(removePos, false);
            }
            Vec3 center = pPos.m_252807_();
            pLevel.m_254951_(null, pLevel.m_269111_().m_269488_(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
        } else {
            if (((Boolean)pState.m_61143_((Property)OCCUPIED)).booleanValue()) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
                return InteractionResult.SUCCESS;
            }
            pPlayer.m_7720_(pPos).ifLeft(sleepingProblem -> {
                if (sleepingProblem.m_36423_() != null) {
                    pPlayer.m_5661_(sleepingProblem.m_36423_(), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

