/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.LanternPlaceState;
import net.redchujelly.cluttered.block.custom.furniture.SmallLampBlock;

public class HoppinParkLantern
extends SmallLampBlock {
    public static final EnumProperty<LanternPlaceState> PLACE_STATE = EnumProperty.m_61587_((String)"place_state", LanternPlaceState.class);
    private static final VoxelShape LANTERN_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0)});
    private static final VoxelShape LANTERN_SHAPE_UP = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    private static final VoxelShape WALL_SHAPE_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)5.0, (double)1.0, (double)8.5, (double)14.0, (double)10.0), Block.m_49796_((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)11.0, (double)12.0), Block.m_49796_((double)4.0, (double)8.0, (double)5.0, (double)12.0, (double)9.0, (double)13.0)});
    private static final VoxelShape WALL_SHAPE_S = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)5.0, (double)6.0, (double)8.5, (double)14.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)11.0, (double)10.0), Block.m_49796_((double)4.0, (double)8.0, (double)3.0, (double)12.0, (double)9.0, (double)11.0)});
    private static final VoxelShape WALL_SHAPE_E = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)5.0, (double)7.5, (double)15.0, (double)14.0, (double)8.5), Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0), Block.m_49796_((double)3.0, (double)8.0, (double)4.0, (double)11.0, (double)9.0, (double)12.0)});
    private static final VoxelShape WALL_SHAPE_W = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)15.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)5.0, (double)7.5, (double)10.0, (double)14.0, (double)8.5), Block.m_49796_((double)6.0, (double)0.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0), Block.m_49796_((double)5.0, (double)8.0, (double)4.0, (double)13.0, (double)9.0, (double)12.0)});

    public HoppinParkLantern(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PLACE_STATE, (Comparable)((Object)LanternPlaceState.FLOOR)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        LanternPlaceState shouldPlaceOn;
        boolean isWaterlogged = pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        Direction surface = pContext.m_43719_();
        Direction facing = pContext.m_8125_().m_122424_();
        if (surface.equals((Object)Direction.UP)) {
            shouldPlaceOn = LanternPlaceState.FLOOR;
        } else if (surface.equals((Object)Direction.DOWN)) {
            shouldPlaceOn = LanternPlaceState.CEILING;
        } else {
            shouldPlaceOn = LanternPlaceState.WALL;
            facing = pContext.m_43719_().m_122424_();
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(PLACE_STATE, (Comparable)((Object)shouldPlaceOn))).m_61124_((Property)f_54117_, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        LanternPlaceState placedOn = (LanternPlaceState)((Object)pState.m_61143_(PLACE_STATE));
        if (placedOn.equals((Object)LanternPlaceState.FLOOR)) {
            return LANTERN_SHAPE;
        }
        if (placedOn.equals((Object)LanternPlaceState.CEILING)) {
            return LANTERN_SHAPE_UP;
        }
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        switch (facing) {
            case SOUTH: {
                return WALL_SHAPE_S;
            }
            case EAST: {
                return WALL_SHAPE_E;
            }
            case WEST: {
                return WALL_SHAPE_W;
            }
        }
        return WALL_SHAPE_N;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{PLACE_STATE});
    }
}

