/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.redchujelly.cluttered.client.ChairEntityRenderer;
import net.redchujelly.cluttered.config.ClutteredCommonConfigs;
import net.redchujelly.cluttered.datagen.DataGeneration;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.ClutteredLootModifiers;
import net.redchujelly.cluttered.setup.CreativeTabRegistration;
import net.redchujelly.cluttered.setup.EntityTypeRegistration;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;
import net.redchujelly.cluttered.setup.ItemRegistration;
import net.redchujelly.cluttered.setup.PaintingRegistration;
import net.redchujelly.cluttered.setup.SoundRegistration;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import net.redchujelly.cluttered.setup.TreeDecoratorTypeRegistration;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;
import net.redchujelly.cluttered.util.ClutteredFurnitureUpdater;
import net.redchujelly.cluttered.util.ClutteredWoodTypes;
import org.slf4j.Logger;

@Mod(value="cluttered")
public class Cluttered {
    public static final String MODID = "cluttered";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Cluttered() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SoundRegistration.register(modEventBus);
        CreativeTabRegistration.register(modEventBus);
        ItemRegistration.register(modEventBus);
        TileEntityRegistration.register(modEventBus);
        BlockRegistration.register(modEventBus);
        EntityTypeRegistration.register(modEventBus);
        PaintingRegistration.register(modEventBus);
        TrunkPlacerTypeRegistration.register(modEventBus);
        FoliagePlacerTypeRegistration.register(modEventBus);
        TreeDecoratorTypeRegistration.register(modEventBus);
        ClutteredLootModifiers.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ClutteredCommonConfigs.SPEC, "cluttered-common.toml");
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(DataGeneration::generate);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.WILLOW_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.FLOWERING_CARPET_WILLOW.get()).m_5456_(), 0.075f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.WILLOW_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.WILLOW_VINES.get()).m_5456_(), 0.5f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.POPLAR_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.FLOWERING_CARPET_POPLAR.get()).m_5456_(), 0.075f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.POPLAR_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.CRABAPPLE_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.FLOWERING_CARPET_CRABAPPLE.get()).m_5456_(), 0.075f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.CRABAPPLE_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.SYCAMORE_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.SYCAMORE_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.MAPLE_LEAVES_FLOWERING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.MAPLE_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.MAPLE_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.BLUE_MUSHROOM_SAPLING.get()).m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)((Block)BlockRegistration.RED_MUSHROOM_SAPLING.get()).m_5456_(), 0.65f);
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.WILLOW_SAPLING.getId(), BlockRegistration.POTTED_WILLOW_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.POPLAR_SAPLING.getId(), BlockRegistration.POTTED_POPLAR_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.CRABAPPLE_SAPLING.getId(), BlockRegistration.POTTED_CRABAPPLE_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.SYCAMORE_SAPLING.getId(), BlockRegistration.POTTED_SYCAMORE_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.MAPLE_SAPLING.getId(), BlockRegistration.POTTED_MAPLE_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.BLUE_MUSHROOM_SAPLING.getId(), BlockRegistration.POTTED_BLUE_MUSHROOM_SAPLING);
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(BlockRegistration.RED_MUSHROOM_SAPLING.getId(), BlockRegistration.POTTED_RED_MUSHROOM_SAPLING);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void missingMappingsHandler(MissingMappingsEvent event) {
        String newId;
        Block replacement;
        String name;
        String missingId;
        if (!((Boolean)ClutteredCommonConfigs.REPLACE_OLD_CLUTTERED_FURNITURE.get()).booleanValue()) {
            return;
        }
        List missingBlocks = event.getAllMappings(ForgeRegistries.Keys.BLOCKS);
        List missingItems = event.getAllMappings(ForgeRegistries.Keys.ITEMS);
        for (MissingMappingsEvent.Mapping missing : missingBlocks) {
            missingId = missing.getKey().toString();
            if (!missingId.startsWith("luphieclutteredmod:")) continue;
            name = missingId.replace("luphieclutteredmod:", "");
            replacement = ClutteredFurnitureUpdater.getUpdatedName(name);
            if (replacement == null) {
                missing.ignore();
                continue;
            }
            missing.remap((Object)replacement);
            newId = replacement.m_7705_().replace("block.cluttered.", "cluttered:");
            LOGGER.debug("remapped {} to {}", (Object)missingId, (Object)newId);
        }
        for (MissingMappingsEvent.Mapping missing : missingItems) {
            missingId = missing.getKey().toString();
            if (!missingId.startsWith("luphieclutteredmod:")) continue;
            name = missingId.replace("luphieclutteredmod:", "");
            replacement = ClutteredFurnitureUpdater.getUpdatedName(name);
            if (replacement == null) {
                missing.ignore();
                continue;
            }
            newId = replacement.m_7705_().replace("block.cluttered.", "cluttered:");
            LOGGER.debug("remapped {} to {}", (Object)missingId, (Object)newId);
        }
    }

    @Mod.EventBusSubscriber(modid="cluttered", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.WILLOW);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.FLOWERING_WILLOW);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.POPLAR);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.FLOWERING_POPLAR);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.CRABAPPLE);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.FLOWERING_CRABAPPLE);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.SYCAMORE);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.MAPLE);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.RED_MUSHROOM);
            Sheets.addWoodType((WoodType)ClutteredWoodTypes.BLUE_MUSHROOM);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityTypeRegistration.CHAIR_ENTITY.get(), ChairEntityRenderer::new);
        }
    }
}

