/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Vector4f;

public class SpellWheelOverlay
implements IGuiOverlay {
    public static SpellWheelOverlay instance = new SpellWheelOverlay();
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    private final Vector4f lineColor = new Vector4f(1.0f, 0.85f, 0.7f, 1.0f);
    private final Vector4f radialButtonColor = new Vector4f(0.04f, 0.03f, 0.01f, 0.6f);
    private final Vector4f highlightColor = new Vector4f(0.8f, 0.7f, 0.55f, 0.7f);
    private final double ringInnerEdge = 20.0;
    private double ringOuterEdge = 80.0;
    private final double ringOuterEdgeMax = 80.0;
    private final double ringOuterEdgeMin = 65.0;
    public boolean active;
    private int wheelSelection;
    private SpellSelectionManager swsm;

    public void open() {
        this.active = true;
        this.wheelSelection = -1;
        Minecraft.m_91087_().f_91067_.m_91602_();
    }

    public void close() {
        this.active = false;
        if (this.wheelSelection >= 0) {
            this.swsm.makeSelection(this.wheelSelection);
        }
        Minecraft.m_91087_().f_91067_.m_91601_();
    }

    public void render(ForgeGui gui, GuiGraphics guiHelper, float partialTick, int screenWidth, int screenHeight) {
        int i;
        if (!this.active) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || minecraft.f_91080_ != null || minecraft.f_91067_.m_91600_()) {
            this.close();
            return;
        }
        this.swsm = ClientMagicData.getSpellSelectionManager();
        int totalSpellsAvailable = this.swsm.getSpellCount();
        if (totalSpellsAvailable <= 0) {
            this.close();
            return;
        }
        PoseStack poseStack = guiHelper.m_280168_();
        poseStack.m_85836_();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        Vec2 screenCenter = new Vec2((float)minecraft.m_91268_().m_85443_() * 0.5f, (float)minecraft.m_91268_().m_85444_() * 0.5f);
        Vec2 mousePos = new Vec2((float)minecraft.f_91067_.m_91589_(), (float)minecraft.f_91067_.m_91594_());
        double radiansPerSpell = Math.toRadians(360.0f / (float)totalSpellsAvailable);
        float mouseRotation = (Utils.getAngle(mousePos, screenCenter) + 1.57f + (float)radiansPerSpell * 0.5f) % 6.283f;
        this.wheelSelection = (int)Mth.m_14008_((double)((double)mouseRotation / radiansPerSpell), (double)0.0, (double)(totalSpellsAvailable - 1));
        if ((double)mousePos.m_165914_(screenCenter) < 4225.0) {
            this.wheelSelection = Math.max(0, this.swsm.getSelectionIndex());
        }
        guiHelper.m_280509_(0, 0, screenWidth, screenHeight, 0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        this.drawRadialBackgrounds(buffer, centerX, centerY, this.wheelSelection);
        this.drawDividingLines(buffer, centerX, centerY);
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        SpellData selectedSpell = this.swsm.getSpellData(this.wheelSelection);
        int spellLevel = selectedSpell.getSpell().getLevelFor(selectedSpell.getLevel(), (LivingEntity)player);
        Font font = gui.m_93082_();
        List<MutableComponent> info = selectedSpell.getSpell().getUniqueInfo(spellLevel, (LivingEntity)minecraft.f_91074_);
        int n = Math.max(2, info.size());
        Objects.requireNonNull(font);
        int textHeight = n * 9 + 5;
        int textCenterMargin = 5;
        int textTitleMargin = 5;
        MutableComponent title = selectedSpell.getSpell().getDisplayName((Player)minecraft.f_91074_).m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)));
        MutableComponent level = Component.m_237110_((String)"ui.irons_spellbooks.level", (Object[])new Object[]{TooltipsUtils.getLevelComponenet(selectedSpell, (LivingEntity)player).m_130948_(selectedSpell.getSpell().getRarity(spellLevel).getDisplayName().m_7383_())});
        MutableComponent mana = Component.m_237110_((String)"ui.irons_spellbooks.mana_cost", (Object[])new Object[]{selectedSpell.getSpell().getManaCost(spellLevel)}).m_130940_(ChatFormatting.AQUA);
        double d = centerX;
        double d2 = centerY;
        double d3 = this.ringOuterEdge + (double)textHeight - (double)textTitleMargin;
        Objects.requireNonNull(font);
        double d4 = d3 - 9.0;
        int n2 = Math.max(2, info.size());
        Objects.requireNonNull(font);
        this.drawTextBackground(guiHelper, d, d2, d4, textCenterMargin, n2 * 9);
        guiHelper.m_280614_(font, (Component)title, centerX - font.m_92852_((FormattedText)title) / 2, (int)((double)centerY - (this.ringOuterEdge + (double)textHeight)), 0xFFFFFF, true);
        int n3 = centerX - font.m_92852_((FormattedText)level) - textCenterMargin;
        double d5 = (double)centerY - (this.ringOuterEdge + (double)textHeight);
        Objects.requireNonNull(font);
        guiHelper.m_280614_(font, (Component)level, n3, (int)(d5 + 9.0 + (double)textTitleMargin), 0xFFFFFF, true);
        int n4 = centerX - font.m_92852_((FormattedText)mana) - textCenterMargin;
        double d6 = (double)centerY - (this.ringOuterEdge + (double)textHeight);
        Objects.requireNonNull(font);
        guiHelper.m_280614_(font, (Component)mana, n4, (int)(d6 + (double)(9 * 2) + (double)textTitleMargin), 0xFFFFFF, true);
        for (int i2 = 0; i2 < info.size(); ++i2) {
            MutableComponent line = info.get(i2);
            double d7 = (double)centerY - (80.0 + (double)textHeight);
            Objects.requireNonNull(font);
            guiHelper.m_280614_(font, (Component)line, centerX + textCenterMargin, (int)(d7 + (double)(9 * (i2 + 1)) + (double)textTitleMargin), 0x3BE33B, true);
        }
        float scale = Mth.m_14179_((float)((float)totalSpellsAvailable / 15.0f), (float)2.0f, (float)1.25f) * 0.65f;
        double radius = (double)(3.0f / scale) * 40.0 * 0.5 * (double)(0.85f + 0.25f * ((float)totalSpellsAvailable / 15.0f));
        Vec2[] locations = new Vec2[totalSpellsAvailable];
        for (i = 0; i < locations.length; ++i) {
            locations[i] = new Vec2((float)(Math.sin(radiansPerSpell * (double)i) * radius), (float)(-Math.cos(radiansPerSpell * (double)i) * radius));
        }
        for (i = 0; i < locations.length; ++i) {
            SpellData spell = this.swsm.getSpellData(i);
            if (spell == null) continue;
            ResourceLocation texture = spell.getSpell().getSpellIconResource();
            poseStack.m_85836_();
            poseStack.m_252880_((float)centerX, (float)centerY, 0.0f);
            poseStack.m_85841_(scale, scale, scale);
            int iconWidth = 8;
            int borderWidth = 16;
            int cdWidth = 8;
            guiHelper.m_280163_(texture, (int)locations[i].f_82470_ - iconWidth, (int)locations[i].f_82471_ - iconWidth, 0.0f, 0.0f, 16, 16, 16, 16);
            guiHelper.m_280218_(TEXTURE, (int)locations[i].f_82470_ - borderWidth, (int)locations[i].f_82471_ - borderWidth, this.swsm.getSelectionIndex() == i ? 32 : 0, 106, 32, 32);
            float f = ClientMagicData.getCooldownPercent(spell.getSpell());
            if (f > 0.0f) {
                RenderSystem.enableBlend();
                int pixels = (int)(16.0f * f + 1.0f);
                guiHelper.m_280218_(TEXTURE, (int)locations[i].f_82470_ - cdWidth, (int)locations[i].f_82471_ + cdWidth - pixels, 47, 87, 16, pixels);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void drawTextBackground(GuiGraphics guiHelper, double centerX, double centerY, double textYOffset, int textCenterMargin, int textHeight) {
        guiHelper.m_280509_(0, 0, (int)(centerX * 2.0), (int)(centerY * 2.0), 0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        centerY = centerY - textYOffset - 2.0;
        int heightMax = textHeight / 2 + 4;
        boolean heightMin = false;
        int widthMax = 70;
        int widthMin = 0;
        widthMin = -1;
        widthMax = 1;
        buffer.m_5483_(centerX + (double)widthMin, centerY + (double)heightMin, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), 0.0f).m_5752_();
        buffer.m_5483_(centerX + (double)widthMin, centerY + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), this.radialButtonColor.w()).m_5752_();
        buffer.m_5483_(centerX + (double)widthMax, centerY + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), this.radialButtonColor.w()).m_5752_();
        buffer.m_5483_(centerX + (double)widthMax, centerY + (double)heightMin, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), 0.0f).m_5752_();
        buffer.m_5483_(centerX + (double)widthMin, centerY + (double)heightMin + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), this.radialButtonColor.w()).m_5752_();
        buffer.m_5483_(centerX + (double)widthMin, centerY + (double)heightMax + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), 0.0f).m_5752_();
        buffer.m_5483_(centerX + (double)widthMax, centerY + (double)heightMax + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), 0.0f).m_5752_();
        buffer.m_5483_(centerX + (double)widthMax, centerY + (double)heightMin + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), this.radialButtonColor.w()).m_5752_();
        buffer.m_5483_(centerX + (double)widthMin, centerY + (double)heightMin + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), this.radialButtonColor.w()).m_5752_();
        buffer.m_5483_(centerX + (double)widthMin, centerY + (double)heightMax + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), 0.0f).m_5752_();
        buffer.m_5483_(centerX + (double)widthMax, centerY + (double)heightMax + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), 0.0f).m_5752_();
        buffer.m_5483_(centerX + (double)widthMax, centerY + (double)heightMin + (double)heightMax, 0.0).m_85950_(this.radialButtonColor.x(), this.radialButtonColor.y(), this.radialButtonColor.z(), this.radialButtonColor.w()).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    private void drawRadialBackgrounds(BufferBuilder buffer, double centerX, double centerY, int selectedSpellIndex) {
        double quarterCircle = 1.5707963267948966;
        int totalSpellsAvailable = this.swsm.getSpellCount();
        int segments = totalSpellsAvailable < 6 ? (totalSpellsAvailable % 2 == 1 ? 15 : 12) : totalSpellsAvailable * 2;
        double radiansPerObject = Math.PI * 2 / (double)segments;
        double radiansPerSpell = Math.PI * 2 / (double)totalSpellsAvailable;
        this.ringOuterEdge = Math.max(65.0, 80.0);
        for (int i = 0; i < segments; ++i) {
            double beginRadians = (double)i * radiansPerObject - (quarterCircle + radiansPerSpell / 2.0);
            double endRadians = (double)(i + 1) * radiansPerObject - (quarterCircle + radiansPerSpell / 2.0);
            double x1m1 = Math.cos(beginRadians) * 20.0;
            double x2m1 = Math.cos(endRadians) * 20.0;
            double y1m1 = Math.sin(beginRadians) * 20.0;
            double y2m1 = Math.sin(endRadians) * 20.0;
            double x1m2 = Math.cos(beginRadians) * this.ringOuterEdge;
            double x2m2 = Math.cos(endRadians) * this.ringOuterEdge;
            double y1m2 = Math.sin(beginRadians) * this.ringOuterEdge;
            double y2m2 = Math.sin(endRadians) * this.ringOuterEdge;
            boolean isHighlighted = i * totalSpellsAvailable / segments == selectedSpellIndex;
            Vector4f color = this.radialButtonColor;
            if (isHighlighted) {
                color = this.highlightColor;
            }
            buffer.m_5483_(centerX + x1m1, centerY + y1m1, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x2m1, centerY + y2m1, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x2m2, centerY + y2m2, 0.0).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            buffer.m_5483_(centerX + x1m2, centerY + y1m2, 0.0).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            color = this.lineColor;
            double categoryLineWidth = 2.0;
            double categoryLineOuterEdge = 20.0 + categoryLineWidth;
            double x1m3 = Math.cos(beginRadians) * categoryLineOuterEdge;
            double x2m3 = Math.cos(endRadians) * categoryLineOuterEdge;
            double y1m3 = Math.sin(beginRadians) * categoryLineOuterEdge;
            double y2m3 = Math.sin(endRadians) * categoryLineOuterEdge;
            buffer.m_5483_(centerX + x1m1, centerY + y1m1, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x2m1, centerY + y2m1, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x2m3, centerY + y2m3, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x1m3, centerY + y1m3, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
        }
    }

    private void drawDividingLines(BufferBuilder buffer, double centerX, double centerY) {
        int totalSpellsAvailable = this.swsm.getSpellCount();
        if (totalSpellsAvailable <= 1) {
            return;
        }
        double quarterCircle = 1.5707963267948966;
        double radiansPerSpell = Math.PI * 2 / (double)totalSpellsAvailable;
        this.ringOuterEdge = Math.max(65.0, 80.0);
        for (int i = 0; i < totalSpellsAvailable; ++i) {
            double closeWidth = 0.13962633907794952;
            double farWidth = 0.03490658476948738;
            double beginCloseRadians = (double)i * radiansPerSpell - (quarterCircle + radiansPerSpell / 2.0) - 0.03490658476948738;
            double endCloseRadians = beginCloseRadians + 0.13962633907794952;
            double beginFarRadians = (double)i * radiansPerSpell - (quarterCircle + radiansPerSpell / 2.0) - 0.008726646192371845;
            double endFarRadians = beginCloseRadians + 0.03490658476948738;
            double x1m1 = Math.cos(beginCloseRadians) * 20.0;
            double x2m1 = Math.cos(endCloseRadians) * 20.0;
            double y1m1 = Math.sin(beginCloseRadians) * 20.0;
            double y2m1 = Math.sin(endCloseRadians) * 20.0;
            double x1m2 = Math.cos(beginFarRadians) * this.ringOuterEdge * 1.4;
            double x2m2 = Math.cos(endFarRadians) * this.ringOuterEdge * 1.4;
            double y1m2 = Math.sin(beginFarRadians) * this.ringOuterEdge * 1.4;
            double y2m2 = Math.sin(endFarRadians) * this.ringOuterEdge * 1.4;
            Vector4f color = this.lineColor;
            buffer.m_5483_(centerX + x1m1, centerY + y1m1, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x2m1, centerY + y2m1, 0.0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
            buffer.m_5483_(centerX + x2m2, centerY + y2m2, 0.0).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            buffer.m_5483_(centerX + x1m2, centerY + y1m2, 0.0).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
        }
    }

    private void setOpaqueTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    private void setTranslucentTexture(ResourceLocation texture) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172649_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    private boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return this.sign(ab) == this.sign(bc) && this.sign(bc) == this.sign(ca);
    }

    private int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }
}

