/*
 * Decompiled with CFR 0.152.
 */
package com.github.nearata.optifinecapes;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="optifinecapes")
public final class OptifineCapes {
    private final Minecraft mc = Minecraft.m_91087_();
    private List<String> players = new ArrayList<String>();

    public OptifineCapes() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public final void renderPlayer(RenderPlayerEvent.Pre event) {
        AbstractClientPlayer acp = (AbstractClientPlayer)event.getEntity();
        String name = acp.m_7755_().getString();
        if (acp.m_108555_() && !this.players.contains(name)) {
            this.players.add(name);
            PlayerInfo playerInfo = acp.m_108558_();
            Util.m_183991_().execute(() -> {
                try {
                    URL url = new URL("http://s.optifine.net/capes/" + name + ".png");
                    NativeImage nativeImage = NativeImage.m_85058_((InputStream)url.openStream());
                    DynamicTexture dynamicTexture = new DynamicTexture(this.parseCape(nativeImage));
                    ResourceLocation resourceLocation = this.mc.m_91097_().m_118490_("optifinecapes/", dynamicTexture);
                    playerInfo.f_105299_.put(MinecraftProfileTexture.Type.CAPE, resourceLocation);
                    playerInfo.f_105299_.put(MinecraftProfileTexture.Type.ELYTRA, resourceLocation);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    @SubscribeEvent
    public final void clientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.f_91074_ == null && !this.players.isEmpty()) {
            this.players.clear();
        }
    }

    private final NativeImage parseCape(NativeImage nativeImageIn) {
        int imageHeight;
        int imageWidth = 64;
        int imageSrcWidth = nativeImageIn.m_84982_();
        int imageSrcHeight = nativeImageIn.m_85084_();
        for (imageHeight = 32; imageWidth < imageSrcWidth || imageHeight < imageSrcHeight; imageWidth *= 2, imageHeight *= 2) {
        }
        NativeImage nativeImage = new NativeImage(imageWidth, imageHeight, true);
        for (int x = 0; x < imageSrcWidth; ++x) {
            for (int y = 0; y < imageSrcHeight; ++y) {
                nativeImage.m_84988_(x, y, nativeImageIn.m_84985_(x, y));
            }
        }
        nativeImageIn.close();
        return nativeImage;
    }
}

