/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.builder;

import com.aetherteam.aether.recipe.builder.PlacementBanBuilder;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.serializer.PlacementBanRecipeSerializer;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBanBuilder
extends PlacementBanBuilder {
    private final BlockStateIngredient ingredient;

    public BlockBanBuilder(BlockStateIngredient ingredient, @Nullable BlockStateIngredient bypassBlock, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> serializer) {
        super(bypassBlock, biomeKey, biomeTag, serializer);
        this.ingredient = ingredient;
    }

    public static PlacementBanBuilder recipe(BlockStateIngredient ingredient, @Nullable ResourceKey<Biome> biomeKey, PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> serializer) {
        return BlockBanBuilder.recipe(ingredient, BlockStateIngredient.EMPTY, biomeKey, null, serializer);
    }

    public static PlacementBanBuilder recipe(BlockStateIngredient ingredient, @Nullable TagKey<Biome> biomeTag, PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> serializer) {
        return BlockBanBuilder.recipe(ingredient, BlockStateIngredient.EMPTY, null, biomeTag, serializer);
    }

    public static PlacementBanBuilder recipe(BlockStateIngredient ingredient, BlockStateIngredient bypassBlock, @Nullable ResourceKey<Biome> biomeKey, PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> serializer) {
        return BlockBanBuilder.recipe(ingredient, bypassBlock, biomeKey, null, serializer);
    }

    public static PlacementBanBuilder recipe(BlockStateIngredient ingredient, BlockStateIngredient bypassBlock, @Nullable TagKey<Biome> biomeTag, PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> serializer) {
        return BlockBanBuilder.recipe(ingredient, bypassBlock, null, biomeTag, serializer);
    }

    public static PlacementBanBuilder recipe(BlockStateIngredient ingredient, BlockStateIngredient bypassBlock, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> serializer) {
        return new BlockBanBuilder(ingredient, bypassBlock, biomeKey, biomeTag, serializer);
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation id) {
        finishedRecipeConsumer.accept(new Result(id, this.getBiomeKey(), this.getBiomeTag(), this.getBypassBlock(), this.ingredient, this.getSerializer()));
    }

    public static class Result
    extends PlacementBanBuilder.Result {
        private final BlockStateIngredient ingredient;

        public Result(ResourceLocation id, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, @Nullable BlockStateIngredient bypassBlock, BlockStateIngredient ingredient, RecipeSerializer<?> serializer) {
            super(id, biomeKey, biomeTag, bypassBlock, serializer);
            this.ingredient = ingredient;
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            json.add("ingredient", this.ingredient.toJson());
        }
    }
}

