/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.util;

public class STCarUtil {
    public static int packRGB(float r, float g, float b) {
        int ir = (int)(r * 255.0f);
        int ig = (int)(g * 255.0f);
        int ib = (int)(b * 255.0f);
        int col = 0;
        col += ir;
        col <<= 8;
        col += ig;
        col <<= 8;
        return col += ib;
    }

    public static float[] RGBtoCMYK(float r, float g, float b) {
        float black = 1.0f - Math.max(r, Math.max(g, b));
        float cyan = (1.0f - r - black) / (1.0f - black);
        float magenta = (1.0f - g - black) / (1.0f - black);
        float yellow = (1.0f - b - black) / (1.0f - black);
        return new float[]{cyan, magenta, yellow, black};
    }

    public static float[] CMYKtoRGB(float cyan, float magenta, float yellow, float black) {
        float r = (1.0f - cyan) * (1.0f - black);
        float g = (1.0f - magenta) * (1.0f - black);
        float b = (1.0f - yellow) * (1.0f - black);
        return new float[]{r, g, b};
    }

    public static float[] rgbToHsv(int[] rgb) {
        return STCarUtil.rgbToHsv((float)rgb[0] / 255.0f, (float)rgb[1] / 255.0f, (float)rgb[2] / 255.0f);
    }

    public static float[] rgbToHsv(int rgb) {
        int r = rgb & 0xFF;
        int g = rgb & 0xFF;
        int b = rgb & 0xFF;
        return STCarUtil.rgbToHsv((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float min;
        float max = Math.max(r, Math.max(g, b));
        float delta = max - (min = Math.min(r, Math.min(g, b)));
        float h = delta == 0.0f ? 0.0f : (max == r ? 60.0f * ((g - b) / delta % 6.0f) : (max == g ? 60.0f * ((b - r) / delta + 2.0f) : 60.0f * ((r - g) / delta + 4.0f)));
        if (h < 0.0f) {
            h += 360.0f;
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        return new float[]{h, s, max};
    }

    public static int[] hsvToRgb(float[] hsv) {
        return STCarUtil.hsvToRgb(hsv[0], hsv[1], hsv[2]);
    }

    public static int[] hsvToRgb(float h, float s, float v) {
        float b;
        float g;
        float r;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h >= 0.0f && h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h >= 60.0f && h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h >= 120.0f && h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h >= 180.0f && h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h >= 240.0f && h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return new int[]{Math.round((r + m) * 255.0f), Math.round((g + m) * 255.0f), Math.round((b + m) * 255.0f)};
    }
}

