/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.util;

import com.storyteam.carmod.content.client.BoostyScreen;
import com.storyteam.carmod.packets.ServerboundStartEntityAnimationPacket;
import com.storyteam.carmod.packets.ServerboundStopEntityAnimationPacket;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.zeith.hammeranims.api.animsys.ConfiguredAnimation;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;

public class STCarClientHelpers {
    public static Entity getEntity(int id) {
        return Minecraft.m_91087_().f_91073_.m_6815_(id);
    }

    public static RegistryAccess getRegistryAccess() {
        return Minecraft.m_91087_().f_91073_.m_9598_();
    }

    public static void openBoostyScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new BoostyScreen());
    }

    public static <T extends Entity> void startEntityAnimation(T entity, String layer, ConfiguredAnimation animation) {
        Network.sendToServer((IPacket)new ServerboundStartEntityAnimationPacket(animation, layer, entity.m_19879_()));
    }

    public static <T extends Entity> void stopEntityAnimation(T entity, String layer) {
        Network.sendToServer((IPacket)new ServerboundStopEntityAnimationPacket(layer, entity.m_19879_()));
    }

    public static void playSoundInEars(SoundEvent soundEvent, float pitch, float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)volume, (float)pitch));
    }

    public static void playSound(double p_233603_, double p_233604_, double p_233605_, SoundEvent p_233606_, SoundSource p_233607_, float p_233608_, float p_233609_, boolean p_233610_) {
        double d0 = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82531_(p_233603_, p_233604_, p_233605_);
        SimpleSoundInstance simplesoundinstance = new SimpleSoundInstance(p_233606_, p_233607_, p_233608_, p_233609_, RandomSource.m_216335_((long)new Random().nextLong()), p_233603_, p_233604_, p_233605_);
        if (p_233610_ && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)simplesoundinstance, (int)(d1 * 20.0));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)simplesoundinstance);
        }
    }

    public static boolean isSameAsClientPlayer(Player player) {
        return Minecraft.m_91087_().f_91074_ == player;
    }

    public static void addParticleWithScale(ParticleOptions particleOptions, double x, double y, double z, double xd, double yd, double zd, float scale) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        Particle particle = particleEngine.m_107370_(particleOptions, x, y, z, xd, yd, zd);
        particle.m_172260_(xd, yd, zd);
        if (particle instanceof SingleQuadParticle) {
            SingleQuadParticle textureSheetParticle = (SingleQuadParticle)particle;
            textureSheetParticle.m_6569_(scale);
        }
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }
}

