/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.storyteam.carmod.STDrive;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.mcf.ModHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="stdrive")
public class DonatorHandler {
    private static Set<String> DONATORS = Set.of();

    @SubscribeEvent
    public static void loadDonators(ServerStartingEvent event) {
        STDrive.LOGGER.info("Loading donators...");
        String url = "https://api.story-team.com/boosters";
        Gson gson = new Gson();
        try {
            String s = HttpRequest.get((CharSequence)url).userAgent("STDrive " + ModHelper.getModVersion((String)"stdrive")).connectTimeout(20000).body();
            JsonArray array = (JsonArray)gson.fromJson(s, JsonArray.class);
            ArrayList<String> strings = new ArrayList<String>(array.asList().stream().map(JsonElement::getAsString).toList());
            STDrive.LOGGER.info("Loaded {} donators.", (Object)strings.size());
            strings.addAll(List.of("FINDERFEED", "klazyt", "Dev", "EL_BlackCat", "Zeitheron"));
            DONATORS = Set.copyOf(strings);
            for (String donator : DONATORS) {
                STDrive.LOGGER.debug("Donator loaded: {}", (Object)donator);
            }
        }
        catch (Exception e) {
            STDrive.LOGGER.error("Failed to load donators", (Throwable)e);
        }
    }

    public static boolean isPlayerDonator(ServerPlayer serverPlayer) {
        String nickname = serverPlayer.m_7755_().getString();
        return DONATORS.contains(nickname);
    }
}

