/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.packets;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class ServerboundStopEntityAnimationPacket
implements IPacket {
    private int entityId;
    private String layerName;

    public ServerboundStopEntityAnimationPacket(String layerName, int entityId) {
        this.layerName = layerName;
        this.entityId = entityId;
    }

    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.writeInt(this.entityId);
        buf.m_130070_(this.layerName);
    }

    public void read(FriendlyByteBuf buf) {
        super.read(buf);
        this.entityId = buf.readInt();
        this.layerName = buf.m_130277_();
    }

    public void serverExecute(PacketContext ctx) {
        super.serverExecute(ctx);
        ServerLevel level = (ServerLevel)ctx.getSender().m_9236_();
        Entity entity = level.m_6815_(this.entityId);
        if (entity instanceof IAnimatedObject) {
            IAnimatedObject animatedObject = (IAnimatedObject)entity;
            animatedObject.getAnimationSystem().stopAnimation(this.layerName);
        }
    }
}

