/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.packets;

import com.storyteam.carmod.content.client.CarLoopingSoundSystem;
import com.storyteam.carmod.content.client.CarSoundInstance;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class SendCarLoopingSoundPacket
implements IPacket {
    public SoundEvent soundEvent;
    public float volume;
    public float pitch;
    public Vec3 worldPos;
    public UUID uuid;

    public SendCarLoopingSoundPacket(UUID uuid, SoundEvent soundEvent, float volume, float pitch, Vec3 worldPos) {
        this.uuid = uuid;
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
        this.worldPos = worldPos;
    }

    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130085_(this.soundEvent.m_11660_());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeDouble(this.worldPos.f_82479_);
        buf.writeDouble(this.worldPos.f_82480_);
        buf.writeDouble(this.worldPos.f_82481_);
        buf.m_130077_(this.uuid);
    }

    public void read(FriendlyByteBuf buf) {
        super.read(buf);
        this.soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buf.m_130281_());
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.worldPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.uuid = buf.m_130259_();
    }

    public void clientExecute(PacketContext ctx) {
        super.clientExecute(ctx);
        CarSoundInstance carSoundInstance = this.worldPos.equals((Object)Vec3.f_82478_) ? new CarSoundInstance(this.uuid, this.soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f) : new CarSoundInstance(this.uuid, this.soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f, this.worldPos.f_82479_, this.worldPos.f_82480_, this.worldPos.f_82481_);
        CarLoopingSoundSystem.addLoopingSound(carSoundInstance);
    }
}

