/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.packets;

import com.storyteam.carmod.util.STCarClientHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;

public class ClientboundPlaySoundForPlayer
implements IPacket {
    public SoundEvent soundEvent;
    public double x;
    public double y;
    public double z;
    public float volume;
    public float pitch;
    public boolean inEars;

    public ClientboundPlaySoundForPlayer(SoundEvent soundEvent, double x, double y, double z, float volume, float pitch, boolean inEars) {
        this.soundEvent = soundEvent;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
        this.inEars = inEars;
    }

    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        ResourceLocation key = ForgeRegistries.SOUND_EVENTS.getKey((Object)this.soundEvent);
        buf.m_130085_(key);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeBoolean(this.inEars);
    }

    public void read(FriendlyByteBuf buf) {
        SoundEvent event;
        super.read(buf);
        ResourceLocation key = buf.m_130281_();
        this.soundEvent = event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(key);
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.inEars = buf.readBoolean();
    }

    public void clientExecute(PacketContext ctx) {
        super.clientExecute(ctx);
        Level level = STCarClientHelpers.getClientLevel();
        if (!this.inEars) {
            STCarClientHelpers.playSound(this.x, this.y, this.z, this.soundEvent, SoundSource.NEUTRAL, this.volume, this.pitch, false);
        } else {
            STCarClientHelpers.playSoundInEars(this.soundEvent, this.pitch, this.volume);
        }
    }
}

