/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.items.neon_rod;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.storyteam.carmod.content.entities.car.NeonRod;
import com.storyteam.carmod.content.items.neon_rod.NeonRodItem;
import com.storyteam.carmod.util.STCarUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class NeonRodRenderer
extends BlockEntityWithoutLevelRenderer {
    public NeonRodRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack item, ItemDisplayContext ctx, PoseStack matrices, MultiBufferSource src, int light, int overlay) {
        matrices.m_85836_();
        Item i = item.m_41720_();
        if (!(i instanceof NeonRodItem)) {
            return;
        }
        NeonRodItem neonRodItem = (NeonRodItem)i;
        NeonRod neonRod = neonRodItem.getNeonRod();
        float red = neonRod.getR();
        float blue = neonRod.getB();
        float green = neonRod.getG();
        float redEnd = red;
        float blueEnd = blue;
        float greenEnd = green;
        if (neonRod.isRainbow()) {
            int tick = (int)(Minecraft.m_91087_().f_91073_.m_46467_() % Integer.MAX_VALUE);
            float partialTicks = Minecraft.m_91087_().m_91104_() ? 0.0f : Minecraft.m_91087_().getPartialTick();
            float hoffs = 30.0f;
            float timeMod = 0.25f;
            float time = ((float)tick + partialTicks) / timeMod;
            int[] rgb1 = STCarUtil.hsvToRgb(time % 360.0f, 1.0f, 1.0f);
            int[] rgb2 = STCarUtil.hsvToRgb((time + hoffs) % 360.0f, 1.0f, 1.0f);
            red = rgb1[0] * 255;
            green = rgb1[1] * 255;
            blue = rgb1[2] * 255;
            redEnd = rgb2[0] * 255;
            blueEnd = rgb2[1] * 255;
            greenEnd = rgb2[2] * 255;
        }
        matrices.m_85837_(0.5, 0.5, 0.5);
        if (ctx == ItemDisplayContext.GUI) {
            matrices.m_252880_(-0.15f, -0.3f, 0.0f);
            matrices.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            matrices.m_85841_(1.8f, 1.8f, 1.8f);
        } else if (ctx == ItemDisplayContext.GROUND) {
            matrices.m_252880_(-0.2f, 0.0f, 0.0f);
        }
        VertexConsumer vertex2 = src.m_6299_(RenderType.m_285907_());
        float c = 0.12f;
        this.renderCube(matrices, vertex2, new Vector3f(-0.1f, 0.0f, 0.0f), 0.1f, 0.05f, c, c, c, c, c, c);
        this.renderCube(matrices, vertex2, new Vector3f(0.4f, 0.0f, 0.0f), 0.1f, 0.05f, c, c, c, c, c, c);
        if (ctx == ItemDisplayContext.GUI) {
            this.renderCube(matrices, vertex2, new Vector3f(), 0.4f, 0.05f, c, c, c, c, c, c);
        }
        VertexConsumer vertex = src.m_6299_(RenderType.m_110502_());
        this.renderCube(matrices, vertex, new Vector3f(), 0.4f, 0.05f, red, green, blue, redEnd, greenEnd, blueEnd);
        matrices.m_85849_();
    }

    private void renderCube(PoseStack matrices, VertexConsumer vertex, Vector3f offset, float length, float radius, float rs, float gs, float bs, float re, float ge, float be) {
        matrices.m_85836_();
        Matrix4f mat = matrices.m_85850_().m_252922_();
        vertex.m_252986_(mat, offset.x, offset.y + radius * 2.0f, offset.z - radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y + radius * 2.0f, offset.z - radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y, offset.z - radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y, offset.z - radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y, offset.z + radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y, offset.z + radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y + radius * 2.0f, offset.z + radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y + radius * 2.0f, offset.z + radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y + radius * 2.0f, offset.z + radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y + radius * 2.0f, offset.z + radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y + radius * 2.0f, offset.z - radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y + radius * 2.0f, offset.z - radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y, offset.z - radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y, offset.z - radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y, offset.z + radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y, offset.z + radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y, offset.z + radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y + radius * 2.0f, offset.z + radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y + radius * 2.0f, offset.z - radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x, offset.y, offset.z - radius).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y, offset.z - radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y + radius * 2.0f, offset.z - radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y + radius * 2.0f, offset.z + radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, offset.x + length, offset.y, offset.z + radius).m_85950_(re, ge, be, 1.0f).m_5752_();
        matrices.m_85849_();
    }
}

