/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.items;

import com.storyteam.carmod.content.entities.car.CarPaint;
import com.storyteam.carmod.content.entities.car.STCarEntity;
import com.storyteam.carmod.content.entities.car.SpecialPaint;
import com.storyteam.carmod.content.items.DonatorItem;
import com.storyteam.carmod.init.STCarItems;
import com.storyteam.carmod.util.STCarClientHelpers;
import com.storyteam.carmod.util.STCarUtil;
import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.joml.Vector3f;

public class SprayPaintItem
extends DonatorItem {
    public SprayPaintItem(Item.Properties properties) {
        super(properties.m_41503_(10));
    }

    public static CarPaint getCarPaint(ItemStack bucket) {
        CompoundTag t = SprayPaintItem.getPaintTag(bucket);
        CompoundTag paint = t.m_128469_("paint");
        CarPaint carPaint = new CarPaint(0, 0, 0);
        carPaint.deserializeNBT(paint);
        return carPaint;
    }

    public static boolean hasPaint(ItemStack itemStack) {
        CompoundTag t = SprayPaintItem.getPaintTag(itemStack);
        return t.m_128441_("paint");
    }

    public static void setCarPaint(ItemStack stack, CarPaint paint) {
        CompoundTag t = SprayPaintItem.getPaintTag(stack);
        CompoundTag tag = paint.serializeNBT();
        t.m_128365_("paint", (Tag)tag);
    }

    public static CompoundTag getPaintTag(ItemStack itemStack) {
        CompoundTag t = itemStack.m_41784_();
        if (!t.m_128441_("carPaint")) {
            t.m_128365_("carPaint", (Tag)new CompoundTag());
        }
        return t.m_128469_("carPaint");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        super.m_5929_(level, livingEntity, stack, remainingUseDuration);
        if (livingEntity instanceof Player) {
            Entity entity;
            Vec3 end;
            Vec3 eyePos;
            EntityHitResult hitResult;
            Player player = (Player)livingEntity;
            double distance = 5.0;
            if (livingEntity.m_21204_().m_22171_((Attribute)ForgeMod.ENTITY_REACH.get())) {
                distance = livingEntity.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()).m_22135_();
            }
            if ((hitResult = ProjectileUtil.m_37287_((Entity)livingEntity, (Vec3)(eyePos = livingEntity.m_146892_()), (Vec3)(end = eyePos.m_82549_(livingEntity.m_20154_().m_82542_(distance, distance, distance))), (AABB)new AABB(eyePos, end), e -> e instanceof STCarEntity, (double)distance)) != null && (entity = hitResult.m_82443_()) instanceof STCarEntity) {
                STCarEntity car = (STCarEntity)entity;
                CarPaint carPaint = SprayPaintItem.getCarPaint(stack);
                if (!level.f_46443_) {
                    if (remainingUseDuration % 5 == 0 && car.checkOwner(player) && carPaint != null) {
                        if (stack.m_41773_() != stack.m_41776_() || player.m_7500_()) {
                            car.paintCar(carPaint);
                            if (!player.m_7500_()) {
                                stack.m_41721_(stack.m_41773_() + 1);
                            }
                            if (stack.m_41773_() == stack.m_41776_()) {
                                car.removeHandItem(player, player.m_7655_());
                            }
                        } else {
                            car.removeHandItem(player, player.m_7655_());
                        }
                    }
                } else {
                    Vec3 l = livingEntity.m_20154_().m_82524_(1.5707964f);
                    Vec3 speed = livingEntity.m_20154_().m_82520_(l.f_82479_ * (double)(level.f_46441_.m_188501_() - 0.5f), l.f_82480_ * (double)(level.f_46441_.m_188501_() - 0.5f), l.f_82480_ * (double)(level.f_46441_.m_188501_() - 0.5f)).m_82541_().m_82542_((double)0.1f, (double)0.1f, (double)0.1f);
                    Vec3 ppos = eyePos.m_82549_(l.m_82548_().m_82542_(0.2, 0.2, 0.2));
                    STCarClientHelpers.addParticleWithScale((ParticleOptions)new DustParticleOptions(new Vector3f(carPaint.getR(), carPaint.getG(), carPaint.getB()), 1.0f), ppos.f_82479_, ppos.f_82480_ - (double)0.1f, ppos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_, 1.0f);
                }
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        if (stack.m_41773_() == stack.m_41776_()) {
            return 0;
        }
        return 72000;
    }

    public static ItemStack generateRandom(RandomSource random) {
        float c = random.m_188501_();
        float m = random.m_188501_();
        float y = random.m_188501_();
        float k = random.m_188501_() * Math.max(0.5f, Math.max(c, Math.max(m, y)));
        CarPaint carPaint = new CarPaint(SpecialPaint.NO, c, m, y, k);
        ItemStack itemStack = STCarItems.SPRAY_PAINT.m_7968_();
        SprayPaintItem.setCarPaint(itemStack, carPaint);
        return itemStack;
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!level.f_46443_ && !SprayPaintItem.hasPaint(stack)) {
            RandomSource random = level.f_46441_;
            float c = random.m_188501_();
            float m = random.m_188501_();
            float y = random.m_188501_();
            float k = random.m_188501_() * Math.max(0.5f, Math.max(c, Math.max(m, y)));
            CarPaint carPaint = new CarPaint(SpecialPaint.NO, c, m, y, k);
            SprayPaintItem.setCarPaint(stack, carPaint);
        }
    }

    @Override
    public boolean shouldThrowOutIfNotDonator(ItemStack itemStack, ServerPlayer player) {
        return SprayPaintItem.getCarPaint(itemStack).getSpecialPaint() == SpecialPaint.APOCALYPSE_CAR_DONATOR;
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, context, tooltipComponents, tooltipFlag);
        if (SprayPaintItem.hasPaint(stack)) {
            CarPaint carPaint = SprayPaintItem.getCarPaint(stack);
            if (carPaint.getSpecialPaint() == SpecialPaint.NO) {
                tooltipComponents.add((Component)Component.m_237115_((String)"stdrive.word.color").m_7220_((Component)Component.m_237113_((String)":")));
                int packed = STCarUtil.packRGB(carPaint.getR(), carPaint.getG(), carPaint.getB());
                tooltipComponents.add((Component)Component.m_237113_((String)"R: %d".formatted(packed >> 16 & 0xFF)).m_130948_(Style.f_131099_.m_178520_(packed)));
                tooltipComponents.add((Component)Component.m_237113_((String)"G: %d".formatted(packed >> 8 & 0xFF)).m_130948_(Style.f_131099_.m_178520_(packed)));
                tooltipComponents.add((Component)Component.m_237113_((String)"B: %d".formatted(packed & 0xFF)).m_130948_(Style.f_131099_.m_178520_(packed)));
            } else {
                SpecialPaint s = carPaint.getSpecialPaint();
                tooltipComponents.add((Component)Component.m_237115_((String)"stdrive.word.has_special_paint").m_130946_(": ").m_7220_(s.getName()));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

