/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.items;

import com.storyteam.carmod.content.entities.car.STCarEntity;
import com.storyteam.carmod.content.items.DefaultDescriptionItem;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FuelCanisterItem
extends DefaultDescriptionItem {
    private int maxFuel;

    public FuelCanisterItem(Item.Properties properties, int maxFuel) {
        super((Component)Component.m_237115_((String)"stdrive.item_description.fuel_canister"), properties.m_41503_(maxFuel));
        this.maxFuel = maxFuel;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public boolean useOnCar(STCarEntity car, ItemStack fuelItem, float limitPerUse, Player user, InteractionHand hand) {
        float fuel = this.getFuel(fuelItem);
        if (fuel != 0.0f) {
            float fuelToAdd = Mth.m_14036_((float)fuel, (float)0.0f, (float)limitPerUse);
            float overflow = car.addFuel(fuelToAdd);
            if (overflow == fuelToAdd) {
                return false;
            }
            this.setFuel(fuelItem, fuel - fuelToAdd + overflow);
        }
        if (user != null && this.getFuel(fuelItem) == 0.0f) {
            user.m_21008_(hand, ItemStack.f_41583_);
            return false;
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        return super.m_7203_(level, player, usedHand);
    }

    public static CompoundTag getFuelTag(ItemStack itemStack) {
        CompoundTag t = itemStack.m_41784_();
        if (!t.m_128441_("fuel")) {
            t.m_128365_("fuel", (Tag)new CompoundTag());
        }
        return t.m_128469_("fuel");
    }

    public float getFuel(ItemStack itemStack) {
        CompoundTag tag = FuelCanisterItem.getFuelTag(itemStack);
        if (!tag.m_128441_("amount")) {
            tag.m_128350_("amount", (float)this.maxFuel);
        }
        return tag.m_128457_("amount");
    }

    public int getMaxFuel(ItemStack itemStack) {
        CompoundTag t = FuelCanisterItem.getFuelTag(itemStack);
        if (!t.m_128441_("max")) {
            t.m_128350_("max", (float)this.maxFuel);
        }
        return t.m_128451_("max");
    }

    public void setFuel(ItemStack itemStack, float fuel) {
        int maxFuel = this.getMaxFuel(itemStack);
        fuel = Mth.m_14036_((float)fuel, (float)0.0f, (float)maxFuel);
        CompoundTag t = FuelCanisterItem.getFuelTag(itemStack);
        t.m_128350_("amount", fuel);
        int damageValue = Math.round((1.0f - fuel / (float)maxFuel) * (float)itemStack.m_41776_());
        itemStack.m_41721_(damageValue);
    }

    @Override
    public void m_7373_(ItemStack stack, Level context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, context, tooltipComponents, tooltipFlag);
        float max = this.getMaxFuel(stack);
        float current = this.getFuel(stack);
        tooltipComponents.add((Component)Component.m_237115_((String)"stdrive.word.fuel").m_130946_(": %.0f/%.0f".formatted(Float.valueOf(current), Float.valueOf(max))));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

