/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.global_loot_modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.storyteam.carmod.content.items.SprayPaintItem;
import com.storyteam.carmod.init.STCarGLMs;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class DungeonPaintLootModifier
extends LootModifier {
    public static final Codec<DungeonPaintLootModifier> CODEC = RecordCodecBuilder.create(p -> p.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions), (App)Codec.INT.fieldOf("min").forGetter(v -> v.min), (App)Codec.INT.fieldOf("max").forGetter(v -> v.max)).apply((Applicative)p, DungeonPaintLootModifier::new));
    private int min;
    private int max;

    public DungeonPaintLootModifier(LootItemCondition[] conditionsIn, int min, int max) {
        super(conditionsIn);
        this.min = min;
        this.max = max;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource r = context.m_230907_();
        int generatedPaints = this.min;
        int rc = this.max - this.min;
        if (rc > 0) {
            generatedPaints += r.m_188503_(rc + 1);
        }
        for (int i = 0; i < generatedPaints; ++i) {
            ItemStack itemStack = SprayPaintItem.generateRandom(r);
            generatedLoot.add((Object)itemStack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)STCarGLMs.DUNGEON_PAINT.get();
    }
}

