/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.storyteam.carmod.STDrive;
import com.storyteam.carmod.content.entities.car.CarPaint;
import com.storyteam.carmod.content.entities.car.NeonRod;
import com.storyteam.carmod.content.entities.car.STCarEntity;
import com.storyteam.carmod.content.entities.renderers.ColoredVertexConsumer;
import com.storyteam.carmod.init.STCarModels;
import com.storyteam.carmod.util.STCarUtil;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.zeith.hammeranims.api.geometry.model.IPositionalModel;
import org.zeith.hammeranims.core.client.render.entity.BedrockEntityRenderer;

public class ApocalypseCarRenderer
extends BedrockEntityRenderer<STCarEntity> {
    private boolean renderEmissive = false;
    private boolean renderGlass = false;
    private boolean renderBase = false;

    public ApocalypseCarRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, STCarModels.APOCALYPSE_CAR, 0.25f);
        this.f_114477_ = 0.0f;
    }

    public void render(@NotNull STCarEntity entity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack matrices, @NotNull MultiBufferSource src, int pPackedLight) {
        this.renderGlass = false;
        this.renderEmissive = false;
        this.renderBase = true;
        super.m_7392_((LivingEntity)entity, pEntityYaw, pPartialTicks, matrices, src, pPackedLight);
        this.renderGlass = false;
        this.renderEmissive = false;
        this.renderBase = false;
        CarPaint carPaint = entity.getCarPaint();
        super.m_7392_((LivingEntity)entity, pEntityYaw, pPartialTicks, matrices, renderType -> {
            VertexConsumer vertexConsumer = src.m_6299_(renderType);
            return new ColoredVertexConsumer(vertexConsumer, carPaint.getR(), carPaint.getG(), carPaint.getB(), 1.0f);
        }, pPackedLight);
        this.renderGlass = false;
        this.renderEmissive = true;
        this.renderBase = false;
        super.m_7392_((LivingEntity)entity, pEntityYaw, pPartialTicks, matrices, src, pPackedLight);
        NeonRod neonRod = entity.getNeonRod();
        if (neonRod != null && entity.isTurnedOn()) {
            ApocalypseCarRenderer.renderNeon(neonRod, entity, pEntityYaw, pPartialTicks, matrices, src, "NeonFront", 0.2f, 1.2f, 45.0f, 0.0f);
            ApocalypseCarRenderer.renderNeon(neonRod, entity, pEntityYaw, pPartialTicks, matrices, src, "NeonBack", 0.2f, 0.9f, -60.0f, 0.0f);
            ApocalypseCarRenderer.renderNeon(neonRod, entity, pEntityYaw, pPartialTicks, matrices, src, "NeonBack", 0.1f, 0.9f, 0.0f, 0.0f);
            ApocalypseCarRenderer.renderNeon(neonRod, entity, pEntityYaw, pPartialTicks, matrices, src, "NeonLeft", 0.275f, 1.2f, -45.0f, 90.0f);
            ApocalypseCarRenderer.renderNeon(neonRod, entity, pEntityYaw, pPartialTicks, matrices, src, "NeonRight", 0.275f, 1.2f, 45.0f, 90.0f);
        }
        if (entity.m_21524_() != null) {
            this.renderLeash(entity, pPartialTicks, matrices, src, entity.m_21524_());
        }
    }

    public static void renderNeon(NeonRod neonRod, STCarEntity entity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack matrices, @NotNull MultiBufferSource src, String bone, float height, float width, float rotationX, float rotationY) {
        float rs = neonRod.getR();
        float re = neonRod.getR();
        float gs = neonRod.getG();
        float ge = neonRod.getG();
        float bs = neonRod.getB();
        float be = neonRod.getB();
        if (neonRod.isRainbow()) {
            float hoffs = 30.0f;
            float timeMod = 0.25f;
            float time = ((float)entity.f_19797_ + pPartialTicks) / timeMod;
            int[] rgb1 = STCarUtil.hsvToRgb(time % 360.0f, 1.0f, 1.0f);
            int[] rgb2 = STCarUtil.hsvToRgb((time + hoffs) % 360.0f, 1.0f, 1.0f);
            rs = rgb1[0] * 255;
            gs = rgb1[1] * 255;
            bs = rgb1[2] * 255;
            re = rgb2[0] * 255;
            ge = rgb2[1] * 255;
            be = rgb2[2] * 255;
        }
        Matrix4f t = new Matrix4f();
        IPositionalModel positionalModel = entity.getPositionalModel();
        positionalModel.applySystem(pPartialTicks, entity.getAnimationSystem());
        positionalModel.applyBoneTransforms(t, bone);
        matrices.m_85836_();
        VertexConsumer vertex = src.m_6299_(RenderType.m_110502_());
        matrices.m_252781_(Axis.f_252392_.m_252977_(pEntityYaw + 180.0f));
        matrices.m_252931_(t);
        matrices.m_252781_(Axis.f_252392_.m_252977_(rotationY));
        matrices.m_252781_(Axis.f_252495_.m_252977_(rotationX));
        Matrix4f mat = matrices.m_85850_().m_252922_();
        float l = width;
        float h = height;
        vertex.m_252986_(mat, -l, h, 0.0f).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, l, h, 0.0f).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, l, 0.0f, 0.0f).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, -l, 0.0f, 0.0f).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, -l, 0.0f, 0.0f).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        vertex.m_252986_(mat, l, 0.0f, 0.0f).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, l, h, 0.0f).m_85950_(re, ge, be, 1.0f).m_5752_();
        vertex.m_252986_(mat, -l, h, 0.0f).m_85950_(rs, gs, bs, 1.0f).m_5752_();
        matrices.m_85849_();
    }

    protected float getFlipDegrees(STCarEntity livingEntity) {
        return 0.0f;
    }

    protected boolean shouldShowName(STCarEntity entity) {
        return false;
    }

    @Nullable
    protected RenderType getRenderType(STCarEntity livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        ResourceLocation resourcelocation = this.getTextureLocation(livingEntity);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (bodyVisible) {
            if (this.renderEmissive && livingEntity.isTurnedOn()) {
                return RenderType.m_110488_((ResourceLocation)resourcelocation);
            }
            if (this.renderGlass) {
                return RenderType.m_110470_((ResourceLocation)resourcelocation);
            }
            return RenderType.m_110458_((ResourceLocation)resourcelocation);
        }
        return glowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation getTextureLocation(STCarEntity entity) {
        if (this.renderEmissive) {
            return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_emissive.png");
        }
        if (this.renderGlass) {
            return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_glasses.png");
        }
        if (this.renderBase) {
            float storagePercent = entity.getTrunkFullness();
            if (storagePercent == 0.0f) {
                return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_base.png");
            }
            if ((double)storagePercent < 0.25) {
                return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_base0.png");
            }
            if ((double)storagePercent < 0.5) {
                return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_base1.png");
            }
            if ((double)storagePercent < 0.75) {
                return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_base2.png");
            }
            return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_base3.png");
        }
        CarPaint carPaint = entity.getCarPaint();
        ResourceLocation location = carPaint.getSpecialPaintTexture((EntityType<? extends STCarEntity>)entity.m_6095_());
        if (location != null) {
            return location;
        }
        return STDrive.location("textures/entity/apocalypse_car/apocalypse_car_paintable.png");
    }

    public boolean shouldRender(STCarEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return camera.m_113029_(livingEntity.m_20191_().m_82377_(4.0, 1.0, 4.0));
    }

    private <E extends Entity> void renderLeash(STCarEntity p_115462_, float p_115463_, PoseStack p_115464_, MultiBufferSource p_115465_, E p_115466_) {
        int $$29;
        int $$24;
        p_115464_.m_85836_();
        Vec3 $$5 = p_115466_.m_7398_(p_115463_);
        double $$6 = (double)(Mth.m_14179_((float)p_115463_, (float)p_115462_.f_20884_, (float)p_115462_.f_20883_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 $$7 = p_115462_.m_245894_(p_115463_);
        double $$8 = Math.cos($$6) * $$7.f_82481_ + Math.sin($$6) * $$7.f_82479_;
        double $$9 = Math.sin($$6) * $$7.f_82481_ - Math.cos($$6) * $$7.f_82479_;
        double $$10 = Mth.m_14139_((double)p_115463_, (double)p_115462_.f_19854_, (double)p_115462_.m_20185_()) + $$8;
        double $$11 = Mth.m_14139_((double)p_115463_, (double)p_115462_.f_19855_, (double)p_115462_.m_20186_()) + $$7.f_82480_;
        double $$12 = Mth.m_14139_((double)p_115463_, (double)p_115462_.f_19856_, (double)p_115462_.m_20189_()) + $$9;
        p_115464_.m_85837_($$8, $$7.f_82480_, $$9);
        float $$13 = (float)($$5.f_82479_ - $$10);
        float $$14 = (float)($$5.f_82480_ - $$11);
        float $$15 = (float)($$5.f_82481_ - $$12);
        float $$16 = 0.025f;
        VertexConsumer $$17 = p_115465_.m_6299_(RenderType.m_110475_());
        Matrix4f $$18 = p_115464_.m_85850_().m_252922_();
        float $$19 = Mth.m_264536_((float)($$13 * $$13 + $$15 * $$15)) * 0.025f / 2.0f;
        float $$20 = $$15 * $$19;
        float $$21 = $$13 * $$19;
        BlockPos $$22 = BlockPos.m_274446_((Position)p_115462_.m_20299_(p_115463_));
        BlockPos $$23 = BlockPos.m_274446_((Position)p_115466_.m_20299_(p_115463_));
        int $$25 = $$24 = this.m_6086_((Entity)p_115462_, $$22);
        int $$26 = p_115462_.m_9236_().m_45517_(LightLayer.SKY, $$22);
        int $$27 = p_115462_.m_9236_().m_45517_(LightLayer.SKY, $$23);
        for ($$29 = 0; $$29 <= 24; ++$$29) {
            ApocalypseCarRenderer.addVertexPair($$17, $$18, $$13, $$14, $$15, $$24, $$25, $$26, $$27, 0.025f, 0.025f, $$20, $$21, $$29, false);
        }
        for ($$29 = 24; $$29 >= 0; --$$29) {
            ApocalypseCarRenderer.addVertexPair($$17, $$18, $$13, $$14, $$15, $$24, $$25, $$26, $$27, 0.025f, 0.0f, $$20, $$21, $$29, true);
        }
        p_115464_.m_85849_();
    }

    private static void addVertexPair(VertexConsumer p_174308_, Matrix4f p_254405_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float $$15 = (float)p_174321_ / 24.0f;
        int $$16 = (int)Mth.m_14179_((float)$$15, (float)p_174313_, (float)p_174314_);
        int $$17 = (int)Mth.m_14179_((float)$$15, (float)p_174315_, (float)p_174316_);
        int $$18 = LightTexture.m_109885_((int)$$16, (int)$$17);
        float $$19 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float $$20 = 0.5f * $$19;
        float $$21 = 0.4f * $$19;
        float $$22 = 0.3f * $$19;
        float $$23 = p_174310_ * $$15;
        float $$24 = p_174311_ > 0.0f ? p_174311_ * $$15 * $$15 : p_174311_ - p_174311_ * (1.0f - $$15) * (1.0f - $$15);
        float $$25 = p_174312_ * $$15;
        p_174308_.m_252986_(p_254405_, $$23 - p_174319_, $$24 + p_174318_, $$25 + p_174320_).m_85950_($$20, $$21, $$22, 1.0f).m_85969_($$18).m_5752_();
        p_174308_.m_252986_(p_254405_, $$23 + p_174319_, $$24 + p_174317_ - p_174318_, $$25 - p_174320_).m_85950_($$20, $$21, $$22, 1.0f).m_85969_($$18).m_5752_();
    }
}

