/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.entities.car;

import com.storyteam.carmod.STDriveTags;
import com.storyteam.carmod.content.client.CarLoopingSoundSystem;
import com.storyteam.carmod.content.entities.car.CarMovement;
import com.storyteam.carmod.content.entities.car.CarMovementOptions;
import com.storyteam.carmod.content.entities.car.CarPaint;
import com.storyteam.carmod.content.entities.car.CarQuery;
import com.storyteam.carmod.content.entities.car.NeonRod;
import com.storyteam.carmod.content.entities.car.STCarBrokenState;
import com.storyteam.carmod.content.items.CarWrench;
import com.storyteam.carmod.content.items.FuelCanisterItem;
import com.storyteam.carmod.content.items.neon_rod.NeonRodItem;
import com.storyteam.carmod.init.STCarAnimations;
import com.storyteam.carmod.init.STCarEntityDataSerializers;
import com.storyteam.carmod.init.STCarItems;
import com.storyteam.carmod.init.STCarSounds;
import com.storyteam.carmod.packets.ClientboundPlaySoundForPlayer;
import com.storyteam.carmod.packets.ClientboundUpdateTrunkContentsPacket;
import com.storyteam.carmod.packets.RemoveCarLoopingSoundPacket;
import com.storyteam.carmod.packets.SendCarLoopingSoundPacket;
import com.storyteam.carmod.packets.ServerboundSendSpeedForEntityPush;
import com.storyteam.carmod.packets.ServerboundShouldBreakPacket;
import com.storyteam.carmod.util.DonatorHandler;
import com.storyteam.carmod.util.STCarClientHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.zeith.hammeranims.api.animation.IAnimationSource;
import org.zeith.hammeranims.api.animation.interp.Query;
import org.zeith.hammeranims.api.animsys.AnimationSystem;
import org.zeith.hammeranims.api.animsys.IAnimatedObject;
import org.zeith.hammeranims.api.animsys.layer.ActiveAnimation;
import org.zeith.hammeranims.api.animsys.layer.AnimationLayer;
import org.zeith.hammeranims.api.geometry.model.IPositionalModel;
import org.zeith.hammeranims.api.tile.IAnimatedEntity;
import org.zeith.hammeranims.core.init.DefaultsHA;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.util.physics.FrictionRotator;

public abstract class STCarEntity
extends PathfinderMob
implements IAnimatedEntity {
    public static final EntityDataAccessor<Boolean> TURNED_ON = SynchedEntityData.m_135353_(STCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> FUEL = SynchedEntityData.m_135353_(STCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<STCarBrokenState> BROKEN_STATE = SynchedEntityData.m_135353_(STCarEntity.class, STCarEntityDataSerializers.BROKEN_STATE.get());
    public static final EntityDataAccessor<CarPaint> CAR_PAINT = SynchedEntityData.m_135353_(STCarEntity.class, STCarEntityDataSerializers.CAR_PAINT.get());
    public static final EntityDataAccessor<ItemStack> NEON_ROD_ITEM = SynchedEntityData.m_135353_(STCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final String START_STOP_LAYER = "START_STOP";
    public static final String TURN_LAYER = "TURN";
    public static final String WHEELS = "WHEELS";
    public static final String IDLE = "IDLE";
    private boolean shouldExplodeOnDeath = true;
    private AnimationSystem system;
    protected CarMovement carMovement;
    private CarQuery carQuery;
    private PlayerEnderChestContainer trunk;
    private UUID owner;
    private int breakInvulnerableTime = 0;
    private int movingTicker = 0;
    private int turnedOnTicker = 0;
    private int timesFueled = 1;
    public final FrictionRotator fanRotation = new FrictionRotator();
    private ItemStack neonRodItem = ItemStack.f_41583_;
    public boolean givenPremiumNeonRod = false;
    private int startMovingSoundCooldown = 0;
    private int stopMovingSoundCooldown = 0;
    private int carSignalTicks = 0;
    private int entityHits = 0;

    public STCarEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        CarQuery carQuery;
        this.carQuery = carQuery = new CarQuery();
        this.system = AnimationSystem.builder((IAnimatedObject)this).addLayers(new String[]{START_STOP_LAYER}).addLayers(new String[]{TURN_LAYER}).addLayers(new String[]{IDLE}).addLayers(new AnimationLayer.Builder[]{AnimationLayer.builder((String)WHEELS).query((Query)carQuery).persistent(false).preventAutoSync()}).autoSync().build();
        this.carMovement = new CarMovement(this, this.getCarMovementOptions());
        this.carMovement.setMovingListeners(this::onMoveForward, this::onMoveBackward);
        this.carMovement.setTurningListeners(this::onStrafeLeft, this::onStrafeRight, this::onStopStrafing);
        this.carMovement.setBrakesListener(this::onHitBrakes);
        this.trunk = new PlayerEnderChestContainer();
        this.trunk.m_19164_(container -> this.sendTrunkUpdate());
        if (!level.f_46443_) {
            this.setCarPaint(CarPaint.getRandomDefaultPaint(new Random()));
        }
    }

    public abstract CarMovementOptions getCarMovementOptions();

    public void m_8119_() {
        super.m_8119_();
        this.system.tick();
        this.f_20886_ = this.f_20885_;
        this.f_20885_ = this.m_146908_();
        if (!this.m_9236_().f_46443_) {
            this.handleLava();
            this.breakInvulnerableTime = Mth.m_14045_((int)(this.breakInvulnerableTime - 1), (int)0, (int)Integer.MAX_VALUE);
            if (this.isTurnedOn()) {
                this.getAnimationSystem().startAnimationAt(IDLE, (IAnimationSource)STCarAnimations.CAR_IDLE);
            } else {
                this.getAnimationSystem().stopAnimation(IDLE);
            }
            if (this.timesFueled % 5 == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.FUEL_FILL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                ++this.timesFueled;
            }
            this.handleTurnedOn();
            this.handleMovingTickerAndStartSounds();
            this.handleAmbientSounds();
            if (this.neonRodItem != null) {
                this.f_19804_.m_135381_(NEON_ROD_ITEM, (Object)this.neonRodItem);
            } else {
                this.f_19804_.m_135381_(NEON_ROD_ITEM, (Object)ItemStack.f_41583_);
            }
            this.handleFuel();
            this.handleInFire();
            this.handleWater();
            this.handleCarSignal();
        } else {
            if (this.m_20197_().isEmpty()) {
                this.carMovement.currentSpeed = 0.0f;
            }
            this.handleBreaking();
            this.brokenParticles();
            this.clientHandleWheels();
            this.clientHandleFan();
            this.pushEntitiesClient();
            this.updateLoopingSoundPositions();
        }
    }

    public void startCarSignal(ServerPlayer initiator) {
        if (this.m_6688_() == initiator) {
            this.sendLoopingSound(STCarSounds.CAR_SIGNAL.get(), 1.0f, 1.0f);
            this.carSignalTicks = 200;
        }
    }

    public void stopCarSignal(ServerPlayer initiator) {
        if (this.m_6688_() == initiator) {
            this.carSignalTicks = -1;
            this.sendStopLoopingSound(STCarSounds.CAR_SIGNAL.get());
        }
    }

    private void handleCarSignal() {
        if (this.carSignalTicks-- > 0) {
            if (this.carSignalTicks % 5 == 0) {
                this.sendLoopingSound(STCarSounds.CAR_SIGNAL.get(), 1.0f, 1.0f);
            }
        } else if (this.carSignalTicks == 0) {
            this.sendStopLoopingSound(STCarSounds.CAR_SIGNAL.get());
            this.carSignalTicks = -1;
        }
    }

    public void updateLoopingSoundPositions() {
        CarLoopingSoundSystem.updateLoopingSoundWorldPosition(this.m_20148_(), this.getEngineAmbientSound(), this.m_20182_());
        CarLoopingSoundSystem.updateLoopingSoundWorldPosition(this.m_20148_(), this.getBrokenEngineAmbientSound(), this.m_20182_());
        CarLoopingSoundSystem.updateLoopingSoundWorldPosition(this.m_20148_(), this.getFullyBrokenEngineAmbientSound(), this.m_20182_());
        CarLoopingSoundSystem.updateLoopingSoundWorldPosition(this.m_20148_(), this.getEngineRidingSound(), this.m_20182_());
        CarLoopingSoundSystem.updateLoopingSoundWorldPosition(this.m_20148_(), this.getBrokenEngineRidingSound(), this.m_20182_());
        CarLoopingSoundSystem.updateLoopingSoundWorldPosition(this.m_20148_(), STCarSounds.CAR_SIGNAL.get(), this.m_20182_());
    }

    public void pushEntitiesClient() {
        float speed;
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player && STCarClientHelpers.isSameAsClientPlayer(player = (Player)livingEntity) && (speed = (float)this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82553_()) > 0.5f && !this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_(), e -> !this.m_20197_().contains(e)).isEmpty()) {
            Network.sendToServer((IPacket)new ServerboundSendSpeedForEntityPush(this));
        }
    }

    public void pushEntitiesAway(float speedFromClient) {
        if (speedFromClient > 0.5f) {
            for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_(), e -> !this.m_20197_().contains(e))) {
                if (entity instanceof STCarEntity) {
                    Vec3 movement;
                    float length;
                    STCarEntity stCarEntity = (STCarEntity)entity;
                    if (entity == this || !((length = (float)(movement = this.getKnownMovement()).m_82553_()) > 0.0f)) continue;
                    stCarEntity.breakOnce();
                    this.breakOnce();
                    Vec3 between = stCarEntity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    stCarEntity.m_20256_(between);
                    stCarEntity.f_19812_ = true;
                    this.m_20256_(between.m_82548_());
                    this.f_19812_ = true;
                    continue;
                }
                if (this.m_6688_() != null) {
                    entity.m_6469_(this.m_9236_().m_269111_().m_269333_(this.m_6688_()), 10.0f * speedFromClient);
                }
                Vec3 v = entity.m_20182_().m_82546_(this.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                Vec3 forward = this.getForwardVector();
                Vec3 left = forward.m_82524_(1.5707964f);
                if (left.m_82526_(v) < 0.0) {
                    left = left.m_82548_();
                }
                entity.m_20256_(entity.m_20184_().m_82549_(left.m_82549_(forward).m_82541_().m_82542_(0.25, 0.25, 0.25)));
                entity.f_19812_ = true;
            }
        }
    }

    public NeonRod getNeonRod() {
        ItemStack stack = (ItemStack)this.f_19804_.m_135370_(NEON_ROD_ITEM);
        Item item = stack.m_41720_();
        if (item instanceof NeonRodItem) {
            NeonRodItem neonRod = (NeonRodItem)item;
            NeonRod neonRod1 = neonRod.getNeonRod();
            return neonRod1;
        }
        return null;
    }

    private void handleWater() {
        if (!this.m_9236_().f_46443_ && this.checkFullInWater()) {
            this.setTurnedOnState(false);
        }
    }

    public boolean m_20069_() {
        return super.m_20069_();
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void setNeonRodItem(ItemStack neonRodItem) {
        this.neonRodItem = neonRodItem;
    }

    public ItemStack getNeonRodItem() {
        return this.neonRodItem;
    }

    private boolean checkFullInWater() {
        BlockPos pos = this.m_20097_().m_7494_();
        BlockPos pos2 = this.m_20097_().m_6630_(2);
        FluidState s1 = this.m_9236_().m_6425_(pos);
        FluidState s2 = this.m_9236_().m_6425_(pos2);
        return s1.m_192917_((Fluid)Fluids.f_76193_) && s2.m_192917_((Fluid)Fluids.f_76193_);
    }

    private void handleInFire() {
        if (!this.m_9236_().f_46443_ && this.m_6060_()) {
            this.breakOnce();
            this.setTurnedOnState(false);
            this.m_7311_(0);
        }
    }

    private void handleTurnedOn() {
        this.turnedOnTicker = this.isTurnedOn() ? ++this.turnedOnTicker : 0;
    }

    private void handleMovingTickerAndStartSounds() {
        this.startMovingSoundCooldown = Mth.m_14045_((int)(this.startMovingSoundCooldown - 1), (int)0, (int)20);
        this.stopMovingSoundCooldown = Mth.m_14045_((int)(this.stopMovingSoundCooldown - 1), (int)0, (int)20);
        Vec3 movement = this.getHorizontalMovement();
        double speed = movement.m_82553_();
        if (speed > 0.0) {
            if (this.movingTicker == 0 && this.m_6688_() != null && this.isTurnedOn() && this.startMovingSoundCooldown == 0) {
                this.sendSound(STCarSounds.CAR_START_MOVING.get(), 1.0f, 1.0f);
                this.startMovingSoundCooldown = 20;
            }
            ++this.movingTicker;
        } else if (this.movingTicker > 0 && speed < (double)0.1f) {
            if (this.m_6688_() != null && this.isTurnedOn() && this.stopMovingSoundCooldown == 0) {
                this.sendSound(STCarSounds.CAR_STOP_MOVING.get(), 1.0f, 1.0f);
                this.stopMovingSoundCooldown = 20;
            }
            this.movingTicker = 0;
        }
    }

    public void hitBrakes() {
        if (this.m_9236_().f_46443_) {
            this.carMovement.hitBrakes();
        }
    }

    private void handleBreaking() {
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player && STCarClientHelpers.isSameAsClientPlayer(player = (Player)livingEntity)) {
            Vec3 verticalMovement = this.m_20184_().m_82542_(1.0, 0.0, 1.0);
            Vec3 forward = this.getForwardVector();
            double speed = verticalMovement.m_82553_();
            if (speed > (double)this.getBreakSpeed()) {
                float upOffs = this.getBreakUpOffset();
                Vec3 start = this.m_20182_().m_82520_(0.0, (double)upOffs, 0.0);
                float breakDistance = this.getBreakDistance();
                Vec3 end = start.m_82549_(forward.m_82542_((double)breakDistance, (double)breakDistance, (double)breakDistance));
                ClipContext clipContext = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
                BlockHitResult result = this.m_9236_().m_45547_(clipContext);
                if (result.m_6662_() != HitResult.Type.MISS) {
                    Network.sendToServer((IPacket)new ServerboundShouldBreakPacket(this, this.m_20182_()));
                }
            }
        }
    }

    public float getBreakSpeed() {
        return 0.4f;
    }

    public float getBreakDistance() {
        return this.m_20205_() * 1.5f;
    }

    public float getBreakUpOffset() {
        return 1.5f;
    }

    public void onBreakPacket(float speed, Vec3 position) {
        if (speed > this.getBreakSpeed()) {
            Vec3 forward = this.getForwardVector();
            float upOffs = this.getBreakUpOffset();
            Vec3 start = position.m_82520_(0.0, (double)upOffs, 0.0);
            Vec3 end = start.m_82549_(forward.m_82542_((double)this.getBreakDistance(), (double)this.getBreakDistance(), (double)this.getBreakDistance()));
            ClipContext clipContext = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            BlockHitResult result = this.m_9236_().m_45547_(clipContext);
            if (result.m_6662_() != HitResult.Type.MISS) {
                this.breakOnce();
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.CAR_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.carMovement.currentSpeed = 0.0f;
            }
        }
    }

    public boolean m_6072_() {
        return true;
    }

    public void m_20221_(BlockPos p_20222_) {
        super.m_20221_(p_20222_);
    }

    public int m_6078_() {
        return 1;
    }

    public int m_287157_() {
        return super.m_287157_();
    }

    private void handleAmbientSounds() {
        if (this.turnedOnTicker % 5 == 0 && this.turnedOnTicker > 10 && this.isTurnedOn()) {
            if (this.getBrokenState() != STCarBrokenState.BROKEN) {
                LivingEntity livingEntity = this.m_6688_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (this.movingTicker > 25) {
                        if (this.getBrokenState() != STCarBrokenState.INTACT) {
                            this.sendLoopingSound(this.getBrokenEngineRidingSound(), 1.0f, 1.0f);
                            this.sendStopLoopingSound(this.getEngineRidingSound());
                        } else {
                            this.sendLoopingSound(this.getEngineRidingSound(), 1.0f, 1.0f);
                            this.sendStopLoopingSound(this.getBrokenEngineRidingSound());
                        }
                        this.sendStopLoopingSound(this.getEngineAmbientSound());
                        this.sendStopLoopingSound(this.getBrokenEngineAmbientSound());
                    } else {
                        this.handleAmbientAmbientSounds();
                    }
                } else {
                    this.handleAmbientAmbientSounds();
                }
                this.sendStopLoopingSound(this.getFullyBrokenEngineAmbientSound());
            } else {
                this.sendStopLoopingSound(this.getEngineRidingSound());
                this.sendStopLoopingSound(this.getBrokenEngineRidingSound());
                this.sendStopLoopingSound(this.getEngineAmbientSound());
                this.sendStopLoopingSound(this.getBrokenEngineAmbientSound());
                this.sendLoopingSound(this.getFullyBrokenEngineAmbientSound(), 1.0f, 1.0f);
            }
        }
    }

    private void handleAmbientAmbientSounds() {
        if (this.getBrokenState() != STCarBrokenState.INTACT) {
            this.sendLoopingSound(this.getBrokenEngineAmbientSound(), 1.0f, 1.0f);
            this.sendStopLoopingSound(this.getEngineAmbientSound());
        } else {
            this.sendLoopingSound(this.getEngineAmbientSound(), 1.0f, 1.0f);
            this.sendStopLoopingSound(this.getBrokenEngineAmbientSound());
        }
        this.sendStopLoopingSound(this.getEngineRidingSound());
        this.sendStopLoopingSound(this.getBrokenEngineRidingSound());
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getEngineRidingSound()), (ServerPlayer)player);
        Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getEngineAmbientSound()), (ServerPlayer)player);
        Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getBrokenEngineAmbientSound()), (ServerPlayer)player);
        Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getBrokenEngineRidingSound()), (ServerPlayer)player);
        Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getFullyBrokenEngineAmbientSound()), (ServerPlayer)player);
    }

    private Vec3 getHorizontalMovement() {
        return this.getKnownMovement().m_82542_(1.0, 0.0, 1.0);
    }

    protected SoundEvent getBrokenEngineRidingSound() {
        return STCarSounds.BROKEN_ENGINE_RIDING.get();
    }

    protected SoundEvent getEngineRidingSound() {
        return STCarSounds.ENGINE_RIDING.get();
    }

    protected SoundEvent getEngineAmbientSound() {
        return STCarSounds.ENGINE_AMBIENT.get();
    }

    protected SoundEvent getBrokenEngineAmbientSound() {
        return STCarSounds.BROKEN_ENGINE_AMBIENT.get();
    }

    protected SoundEvent getFullyBrokenEngineAmbientSound() {
        return STCarSounds.ENGINE_FULL_BROKEN.get();
    }

    public void sendLoopingSound(SoundEvent soundEvent, float pitch, float volume) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        List serverPlayers = serverLevel.m_45976_(ServerPlayer.class, this.m_20191_().m_82400_((double)(volume * 18.0f)));
        for (ServerPlayer serverPlayer : serverPlayers) {
            if (this.m_20197_().contains(serverPlayer)) {
                Network.sendTo((IPacket)new SendCarLoopingSoundPacket(this.m_20148_(), soundEvent, volume, pitch, Vec3.f_82478_), (ServerPlayer)serverPlayer);
                continue;
            }
            Network.sendTo((IPacket)new SendCarLoopingSoundPacket(this.m_20148_(), soundEvent, volume, pitch, this.m_20182_()), (ServerPlayer)serverPlayer);
        }
    }

    public void sendStopLoopingSound(SoundEvent soundEvent) {
        Network.sendToTracking((Entity)this, (IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), soundEvent));
    }

    public void sendSound(SoundEvent soundEvent, float pitch, float volume) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        List serverPlayers = serverLevel.m_45976_(ServerPlayer.class, this.m_20191_().m_82400_((double)(volume * 18.0f)));
        for (ServerPlayer serverPlayer : serverPlayers) {
            if (this.m_20197_().contains(serverPlayer)) {
                Network.sendTo((IPacket)new ClientboundPlaySoundForPlayer(soundEvent, 0.0, 0.0, 0.0, volume, pitch, true), (ServerPlayer)serverPlayer);
                continue;
            }
            Network.sendTo((IPacket)new ClientboundPlaySoundForPlayer(soundEvent, this.m_20185_(), this.m_20186_(), this.m_20189_(), volume, pitch, false), (ServerPlayer)serverPlayer);
        }
    }

    private void handleLava() {
        if (!this.m_9236_().f_46443_ && this.m_20077_()) {
            if (this.getBrokenState() != STCarBrokenState.BROKEN) {
                this.breakOnce();
            } else {
                this.m_6074_();
            }
        }
    }

    private void brokenParticles() {
        Vec3 bonePos = this.getBonePos("BrokenSmoke");
        if (bonePos != null) {
            STCarBrokenState state = this.getBrokenState();
            if (state == STCarBrokenState.BROKEN || state == STCarBrokenState.DAMAGED) {
                STCarClientHelpers.addParticleWithScale((ParticleOptions)ParticleTypes.f_123777_, bonePos.f_82479_ + (double)this.f_19796_.m_188501_() * 0.5 - 0.25, bonePos.f_82480_, bonePos.f_82481_ + (double)this.f_19796_.m_188501_() * 0.5 - 0.25, 0.0, 0.005 + (double)this.f_19796_.m_188501_() * 0.025, 0.0, 0.5f);
            }
            if (state == STCarBrokenState.BROKEN) {
                STCarClientHelpers.addParticleWithScale((ParticleOptions)ParticleTypes.f_123755_, bonePos.f_82479_ + (double)this.f_19796_.m_188501_() * 0.5 - 0.25, bonePos.f_82480_, bonePos.f_82481_ + (double)this.f_19796_.m_188501_() * 0.5 - 0.25, 0.0, 0.005 + (double)this.f_19796_.m_188501_() * 0.025, 0.0, 0.5f);
            }
        }
    }

    private void handleFuel() {
        if (this.getFuel() == 0.0f) {
            this.setTurnedOnState(false);
        } else {
            Vec3 moveDelta;
            if (this.isTurnedOn()) {
                float fuel = this.getFuel();
                this.setFuel(fuel - this.getPassiveTurnedOnFuelPerTickDecrement());
            }
            if ((moveDelta = this.getKnownMovement().m_82542_(1.0, 0.0, 1.0)).m_82553_() > 0.0) {
                float fuel = this.getFuel();
                this.setFuel(fuel - (float)moveDelta.m_82553_() * this.getFuelOnMoveConsumption());
            }
        }
    }

    private void clientHandleWheels() {
        AnimationLayer layer = this.getAnimationSystem().getLayer(WHEELS);
        ActiveAnimation animation = layer.getCurrentAnimation();
        if (animation == null || !animation.getLocation().equals((Object)STCarAnimations.CAR_WHEELS.getLocation())) {
            layer.startAnimation((IAnimationSource)STCarAnimations.CAR_WHEELS);
        }
        Vec3 r = this.getHorizontalMovementDelta();
        float wheelRotationAdd = (float)r.m_82553_() * 30.0f;
        Vec3 forward = this.getForwardVector();
        this.carQuery.wheelRotationOld = this.carQuery.wheelRotationNow;
        this.carQuery.wheelRotationNow = forward.m_82526_(r) > 0.0 ? (this.carQuery.wheelRotationNow += wheelRotationAdd) : (this.carQuery.wheelRotationNow -= wheelRotationAdd);
    }

    private void clientHandleFan() {
        this.carQuery.fanRotationNow = this.fanRotation;
        this.fanRotation.update();
        if (this.isTurnedOn()) {
            this.fanRotation.speedup(3.0f);
        }
    }

    protected Vec3 getHorizontalMovementDelta() {
        Vec3 r = new Vec3(this.m_20185_(), 0.0, this.m_20189_()).m_82492_(this.f_19854_, 0.0, this.f_19856_);
        return r;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND) {
            ItemStack item = player.m_21120_(hand);
            if (item.m_150930_(STCarItems.APOCALYPSE_CAR_KEYS)) {
                if (this.assignOrCheckOwner((ServerPlayer)player)) {
                    if (!this.getBrokenState().equals((Object)STCarBrokenState.BROKEN) || this.isTurnedOn()) {
                        this.setTurnedOnState(!this.isTurnedOn());
                        if (this.getFuel() != 0.0f) {
                            if (this.isTurnedOn()) {
                                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.ENGINE_TURN_ON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            } else {
                                this.sendStopLoopingSound(this.getEngineRidingSound());
                                this.sendStopLoopingSound(this.getEngineAmbientSound());
                                this.sendStopLoopingSound(this.getBrokenEngineRidingSound());
                                this.sendStopLoopingSound(this.getBrokenEngineAmbientSound());
                                this.sendStopLoopingSound(this.getFullyBrokenEngineAmbientSound());
                                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.ENGINE_TURN_OFF.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                        }
                    } else {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.ENGINE_FULL_BROKEN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                return InteractionResult.CONSUME;
            }
            Item item2 = item.m_41720_();
            if (item2 instanceof FuelCanisterItem) {
                FuelCanisterItem fuelCanisterItem = (FuelCanisterItem)item2;
                if (player.m_20202_() != this && fuelCanisterItem.useOnCar(this, item, 20.0f, player, hand)) {
                    ++this.timesFueled;
                }
                return InteractionResult.CONSUME;
            }
            if (item.m_150930_(STCarItems.SPRAY_PAINT)) {
                return InteractionResult.PASS;
            }
            if (item.m_150930_(STCarItems.REPAIR_KIT)) {
                if (this.getBrokenState() != STCarBrokenState.INTACT) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                    this.setBrokenState(STCarBrokenState.INTACT);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.FIX_CAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResult.CONSUME;
            }
            item2 = item.m_41720_();
            if (item2 instanceof NeonRodItem) {
                NeonRodItem neonRodItem = (NeonRodItem)item2;
                if (this.checkOwner(player) && (!item.m_204117_(STDriveTags.SPONSOR_ITEM) || item.m_204117_(STDriveTags.SPONSOR_ITEM) && DonatorHandler.isPlayerDonator((ServerPlayer)player))) {
                    ItemStack previous = this.neonRodItem;
                    this.neonRodItem = item;
                    if (!previous.m_204117_(STDriveTags.SPONSOR_ITEM)) {
                        player.m_21008_(hand, previous);
                    } else {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
            } else if (player.m_6047_()) {
                this.openTrunk(player);
            } else if (item.m_41720_() != Items.f_42655_ && !(item.m_41720_() instanceof CarWrench)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                if (player.m_7998_((Entity)this, false)) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.DOOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult m_7111_(Player user, Vec3 pos, InteractionHand hand) {
        CarWrench carWrench;
        Item item;
        if (!user.m_9236_().f_46443_ && (item = user.m_21120_(hand).m_41720_()) instanceof CarWrench && (carWrench = (CarWrench)item).useOnCar(user, this, pos)) {
            return InteractionResult.CONSUME;
        }
        return super.m_7111_(user, pos, hand);
    }

    public void removeHandItem(Player player, InteractionHand hand) {
        if (!player.m_7500_()) {
            player.m_21008_(hand, ItemStack.f_41583_);
        }
    }

    private void openTrunk(Player player) {
        Level level;
        if (this.checkOwner(player) || player.m_7500_()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, owner) -> ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this.getTrunk()), (Component)Component.m_237115_((String)"carmod.trunk")));
        }
        if ((level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.TRUNK_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public boolean checkOwner(Player player) {
        return this.owner != null && player.m_20148_().equals(this.owner);
    }

    public boolean assignOrCheckOwner(ServerPlayer player) {
        if (this.owner == null) {
            this.owner = player.m_20148_();
            return true;
        }
        return this.checkOwner((Player)player);
    }

    protected void m_274498_(Player player, Vec3 travelVector) {
        super.m_274498_(player, travelVector);
    }

    protected float m_245547_(Player player) {
        float speed = (float)this.m_21133_(Attributes.f_22279_);
        if (this.getBrokenState() == STCarBrokenState.DAMAGED) {
            speed *= 0.25f;
        } else if (this.getBrokenState() == STCarBrokenState.BROKEN) {
            speed = 0.0f;
        }
        return speed;
    }

    public void m_6667_(DamageSource src) {
        if (!this.m_9236_().f_46443_ && src.m_276093_(DamageTypes.f_286979_)) {
            this.shouldExplodeOnDeath = false;
        }
        super.m_6667_(src);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)entity;
            if (!(source.m_7639_() instanceof Player)) {
                if (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_)) {
                    this.breakOnce();
                } else {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11664_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (++this.entityHits % 10 == 0) {
                        this.breakOnce();
                    }
                }
            }
        } else if (source.m_276093_(DamageTypes.f_268565_)) {
            this.breakOnce();
        }
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (!this.m_9236_().f_46443_ && this.shouldExplodeOnDeath) {
            Vec3 forward = this.getForwardVector();
            if (this.f_20919_ % 2 == 1) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_() + forward.f_82479_ + (double)(this.f_19796_.m_188501_() * 2.0f) - 1.0, this.m_20186_() + (double)this.f_19796_.m_188501_(), this.m_20189_() + forward.f_82481_ + (double)(this.f_19796_.m_188501_() * 2.0f) - 1.0, (float)(3 + this.f_19796_.m_188503_(2)), Level.ExplosionInteraction.BLOCK);
            } else {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_() - forward.f_82479_ + (double)(this.f_19796_.m_188501_() * 2.0f) - 1.0, this.m_20186_() + (double)this.f_19796_.m_188501_(), this.m_20189_() - forward.f_82481_ + (double)(this.f_19796_.m_188501_() * 2.0f) - 1.0, (float)(3 + this.f_19796_.m_188503_(2)), Level.ExplosionInteraction.BLOCK);
            }
        }
        if (this.f_20919_ >= 5 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_142066_() {
        return this.getBrokenState() != STCarBrokenState.BROKEN;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        int index = this.m_20197_().indexOf(entity);
        Vec3 bonePos = this.getBonePos("Passenger" + index);
        if (bonePos != null) {
            return bonePos;
        }
        return this.m_20182_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction function) {
        int index = this.m_20197_().indexOf(entity);
        if (index != -1) {
            Vec3 pos = this.getPassengerRidingPosition(entity);
            entity.m_146884_(pos.m_82520_(0.0, -0.6, 0.0));
        } else {
            super.m_19956_(entity, function);
        }
    }

    public Vec3 getBonePos(String boneName) {
        IPositionalModel model = this.getPositionalModel();
        if (model.hasBone(boneName)) {
            model.applySystem(1.0f, this.getAnimationSystem());
            Matrix4d mat = new Matrix4d();
            mat.rotateY(-Math.toRadians(180.0f + this.m_146908_()));
            model.applyBoneTransforms(mat, boneName);
            Vector3d v = new Vector3d();
            v = mat.transformPosition(v);
            return new Vec3(v.x, v.y, v.z).m_82549_(this.m_20182_());
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 forwardVector = this.getForwardVector();
        return this.m_20182_().m_82549_(forwardVector.m_82524_(1.5707964f).m_82542_(1.5, 1.5, 1.5));
    }

    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.m_20197_().contains(entity)) {
                Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getEngineAmbientSound()), (ServerPlayer)serverPlayer);
                Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getEngineRidingSound()), (ServerPlayer)serverPlayer);
                Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getBrokenEngineRidingSound()), (ServerPlayer)serverPlayer);
                Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getBrokenEngineAmbientSound()), (ServerPlayer)serverPlayer);
                Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getFullyBrokenEngineAmbientSound()), (ServerPlayer)serverPlayer);
            }
        }
    }

    protected void m_20351_(Entity passenger) {
        if (!this.m_9236_().f_46443_ && passenger instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)passenger;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.DOOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getEngineAmbientSound()), (ServerPlayer)serverPlayer);
            Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getEngineRidingSound()), (ServerPlayer)serverPlayer);
            Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getBrokenEngineAmbientSound()), (ServerPlayer)serverPlayer);
            Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getBrokenEngineRidingSound()), (ServerPlayer)serverPlayer);
            Network.sendTo((IPacket)new RemoveCarLoopingSoundPacket(this.m_20148_(), this.getFullyBrokenEngineAmbientSound()), (ServerPlayer)serverPlayer);
            if (serverPlayer.equals((Object)this.m_6688_())) {
                this.carSignalTicks = 0;
                this.sendStopLoopingSound(STCarSounds.CAR_SIGNAL.get());
            }
        }
        super.m_20351_(passenger);
    }

    public Vec3 getForwardVector() {
        Vec3 forwardVector = new Vec3(0.0, 0.0, -1.0).m_82524_(-((float)Math.toRadians(this.m_146908_() + 180.0f)));
        return forwardVector;
    }

    protected Vec3 m_274312_(Player player, Vec3 travelVector) {
        if (this.m_9236_().f_46443_) {
            if (this.getBrokenState() != STCarBrokenState.BROKEN) {
                this.carMovement.tick(player.f_20900_, player.f_20902_);
            } else {
                this.carMovement.tick(0.0f, 0.0f);
            }
        }
        return new Vec3((double)player.f_20900_, 0.0, (double)player.f_20902_);
    }

    public void onHitBrakes() {
        STCarClientHelpers.startEntityAnimation(this, START_STOP_LAYER, STCarAnimations.CAR_STOP.configure().next(DefaultsHA.NULL_ANIM.configure()));
        STCarClientHelpers.playSound(this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.HIT_BRAKES.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, true);
    }

    public void onMoveForward() {
        STCarClientHelpers.startEntityAnimation(this, START_STOP_LAYER, STCarAnimations.CAR_START.configure().next(DefaultsHA.NULL_ANIM.configure()));
    }

    public void onMoveBackward() {
        STCarClientHelpers.startEntityAnimation(this, START_STOP_LAYER, STCarAnimations.CAR_STOP.configure().next(DefaultsHA.NULL_ANIM.configure()));
    }

    public void onStrafeLeft() {
        STCarClientHelpers.startEntityAnimation(this, TURN_LAYER, STCarAnimations.WHEELS_ROTATE_LEFT.configure());
    }

    public void onStrafeRight() {
        STCarClientHelpers.startEntityAnimation(this, TURN_LAYER, STCarAnimations.WHEELS_ROTATE_RIGHT.configure());
    }

    public void onStopStrafing() {
        STCarClientHelpers.stopEntityAnimation(this, TURN_LAYER);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_9236_().f_46443_ && this.m_6688_() == null) {
            this.carMovement.tick(0.0f, 0.0f);
        }
        super.m_7023_(new Vec3(0.0, 0.0, (double)this.carMovement.getSpeedPercent()));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void setTurnedOnState(boolean state) {
        this.f_19804_.m_135381_(TURNED_ON, (Object)state);
    }

    public boolean isTurnedOn() {
        return (Boolean)this.f_19804_.m_135370_(TURNED_ON);
    }

    public float addFuel(float fuel) {
        float f = this.getFuel();
        float newFuelAmount = Mth.m_14036_((float)(fuel + f), (float)0.0f, (float)this.getMaxFuel());
        float overflow = f + fuel - newFuelAmount;
        this.setFuel(newFuelAmount);
        return overflow;
    }

    public void setFuel(float fuel) {
        fuel = Mth.m_14036_((float)fuel, (float)0.0f, (float)this.getMaxFuel());
        this.f_19804_.m_135381_(FUEL, (Object)Float.valueOf(fuel));
    }

    public float getFuel() {
        return ((Float)this.f_19804_.m_135370_(FUEL)).floatValue();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TURNED_ON, (Object)false);
        this.f_19804_.m_135372_(FUEL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BROKEN_STATE, (Object)STCarBrokenState.INTACT);
        this.f_19804_.m_135372_(CAR_PAINT, (Object)new CarPaint(1.0f, 1.0f, 1.0f));
        this.f_19804_.m_135372_(NEON_ROD_ITEM, (Object)ItemStack.f_41583_);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return super.m_6688_();
    }

    public PlayerEnderChestContainer getTrunk() {
        return this.trunk;
    }

    public float getTrunkFullness() {
        int containerSize = this.getTrunk().m_6643_();
        int fullness = 0;
        for (int i = 0; i < containerSize; ++i) {
            if (this.getTrunk().m_8020_(i).m_41619_()) continue;
            ++fullness;
        }
        return (float)fullness / (float)containerSize;
    }

    public STCarBrokenState getBrokenState() {
        return (STCarBrokenState)((Object)this.f_19804_.m_135370_(BROKEN_STATE));
    }

    public void setBrokenState(STCarBrokenState brokenState) {
        this.f_19804_.m_135381_(BROKEN_STATE, (Object)brokenState);
    }

    public CarPaint getCarPaint() {
        return (CarPaint)this.f_19804_.m_135370_(CAR_PAINT);
    }

    public void setCarPaint(CarPaint carPaint) {
        this.f_19804_.m_135381_(CAR_PAINT, (Object)carPaint);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
    }

    public void paintCar(CarPaint other) {
        CarPaint current = this.getCarPaint();
        CarPaint newPaint = current.combineWith(other);
        this.setCarPaint(newPaint);
    }

    public float m_274421_() {
        return 1.5f;
    }

    public void setupSystem(AnimationSystem.Builder builder) {
    }

    public AnimationSystem getAnimationSystem() {
        return this.system;
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public Vec3 getKnownMovement() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_6084_() && this.isTurnedOn()) {
                return player.m_20184_();
            }
        }
        return this.m_20184_();
    }

    public void m_7334_(Entity entity) {
    }

    public void breakOnce() {
        if (this.breakInvulnerableTime == 0) {
            if (this.getBrokenState() == STCarBrokenState.INTACT) {
                this.setBrokenState(STCarBrokenState.DAMAGED);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.CAR_BREAK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.getBrokenState() == STCarBrokenState.DAMAGED) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), STCarSounds.CAR_BREAK.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.setBrokenState(STCarBrokenState.BROKEN);
            }
            this.breakInvulnerableTime = 20;
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6138_() {
        super.m_6138_();
    }

    protected void m_7324_(Entity entity) {
        super.m_7324_(entity);
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public void sendTrunkUpdate() {
        if (!this.m_9236_().f_46443_) {
            Network.sendToTracking((Entity)this, (IPacket)new ClientboundUpdateTrunkContentsPacket(this));
        }
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        Network.sendTo((ServerPlayer)serverPlayer, (IPacket)new ClientboundUpdateTrunkContentsPacket(this));
    }

    protected boolean m_7310_(Entity passenger) {
        int passengers = 0;
        for (Entity p : this.m_20197_()) {
            if (p == null) continue;
            ++passengers;
        }
        return passengers < this.getMaxPassengers();
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
        super.m_7840_(p_20990_, p_20991_, p_20992_, p_20993_);
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        float breakDistance = 6.0f;
        float fullBreakDistance = 20.0f;
        if ((fallDistance *= multiplier) > fullBreakDistance) {
            this.setBrokenState(STCarBrokenState.BROKEN);
            this.fallDamageToPassengers(fallDistance, breakDistance);
            return true;
        }
        if (fallDistance > breakDistance) {
            if (this.getBrokenState() == STCarBrokenState.INTACT) {
                this.setBrokenState(STCarBrokenState.DAMAGED);
            } else if (this.getBrokenState() == STCarBrokenState.DAMAGED) {
                this.setBrokenState(STCarBrokenState.BROKEN);
            }
            this.fallDamageToPassengers(fallDistance, breakDistance);
            return true;
        }
        return false;
    }

    private void fallDamageToPassengers(float fallDistance, float breakDistance) {
        if (!this.m_9236_().f_46443_ && fallDistance > breakDistance) {
            float distAfter = fallDistance - breakDistance;
            float damage = Mth.m_14036_((float)(distAfter / 2.0f), (float)0.0f, (float)10.0f);
            for (Entity passenger : this.m_20197_()) {
                if (!(passenger instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)passenger;
                livingEntity.m_6469_(this.m_9236_().m_269111_().m_268989_(), damage);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        if (this.neonRodItem != null) {
            CompoundTag tag = new CompoundTag();
            this.neonRodItem.m_41739_(tag);
            compound.m_128365_("neonRod", (Tag)tag);
        }
        compound.m_128379_("givenPremiumNeonRod", this.givenPremiumNeonRod);
        if (this.owner != null) {
            compound.m_128362_("owner", this.owner);
        }
        ListTag trunk = this.getTrunk().m_7927_();
        compound.m_128365_("inventory", (Tag)trunk);
        compound.m_128344_("elementType", trunk.m_7264_());
        compound.m_128379_("turnedOn", this.isTurnedOn());
        compound.m_128350_("fuel", this.getFuel());
        String name = this.getBrokenState().name();
        compound.m_128359_("brokenState", name);
        super.m_7380_(compound);
        CompoundTag tag = this.getCarPaint().serializeNBT();
        compound.m_128365_("paint", (Tag)tag);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("neonRod")) {
            CompoundTag tag = compound.m_128469_("neonRod");
            this.neonRodItem = ItemStack.m_41712_((CompoundTag)tag);
        }
        this.givenPremiumNeonRod = compound.m_128471_("givenPremiumNeonRod");
        if (compound.m_128441_("brokenState")) {
            this.setBrokenState(STCarBrokenState.valueOf(compound.m_128461_("brokenState")));
        } else {
            this.setBrokenState(STCarBrokenState.INTACT);
        }
        this.setTurnedOnState(compound.m_128471_("turnedOn"));
        if (compound.m_128441_("owner")) {
            this.owner = compound.m_128342_("owner");
        }
        byte elementType = compound.m_128445_("elementType");
        ListTag inv = compound.m_128437_("inventory", (int)elementType);
        this.getTrunk().m_7797_(inv);
        this.setFuel(compound.m_128457_("fuel"));
        if (compound.m_128441_("paint")) {
            CarPaint paint = new CarPaint(0, 0, 0);
            paint.deserializeNBT(compound.m_128469_("paint"));
            this.setCarPaint(paint);
        }
    }

    public abstract IPositionalModel getPositionalModel();

    public abstract float getMaxFuel();

    public abstract int getMaxPassengers();

    public abstract float getFuelOnMoveConsumption();

    public abstract float getPassiveTurnedOnFuelPerTickDecrement();

    protected void m_6668_(DamageSource p_21192_) {
        if (!this.m_9236_().f_46443_) {
            PlayerEnderChestContainer trunk = this.getTrunk();
            for (int i = 0; i < trunk.m_6643_(); ++i) {
                ItemStack stack = trunk.m_8020_(i);
                if (stack.m_41619_()) continue;
                ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), stack);
                this.m_9236_().m_7967_((Entity)item);
            }
        }
        super.m_6668_(p_21192_);
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, 0.5, 2.5);
    }

    protected double m_5823_() {
        return 0.05f;
    }

    public boolean m_6573_(Player p_21418_) {
        return super.m_6573_(p_21418_);
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    protected void m_6119_() {
        Entity $$0;
        if (!(this.m_21524_() == null || this.m_6084_() && this.m_21524_().m_6084_())) {
            this.m_21455_(true, true);
        }
        if (($$0 = this.m_21524_()) != null && $$0.m_9236_() == this.m_9236_()) {
            this.m_21446_($$0.m_20183_(), 5);
            float $$1 = this.m_20270_($$0);
            this.m_7880_($$1);
            if ($$1 > 10.0f) {
                this.m_21455_(true, true);
                this.f_21345_.m_25355_(Goal.Flag.MOVE);
            } else if ($$1 > 6.0f) {
                double $$2 = ($$0.m_20185_() - this.m_20185_()) / (double)$$1;
                double $$3 = ($$0.m_20186_() - this.m_20186_()) / (double)$$1;
                double $$4 = ($$0.m_20189_() - this.m_20189_()) / (double)$$1;
                Vec3 add = new Vec3(Math.copySign($$2 * $$2 * 0.4, $$2), Math.copySign($$3 * $$3 * 0.4, $$3), Math.copySign($$4 * $$4 * 0.4, $$4)).m_82542_(0.25, 0.25, 0.25);
                this.m_20256_(this.m_20184_().m_82549_(add));
                this.m_245125_();
            } else if (this.m_213814_()) {
                this.f_21345_.m_25374_(Goal.Flag.MOVE);
                float $$5 = 2.0f;
                Vec3 $$6 = new Vec3($$0.m_20185_() - this.m_20185_(), $$0.m_20186_() - this.m_20186_(), $$0.m_20189_() - this.m_20189_()).m_82541_().m_82490_((double)Math.max($$1 - 2.0f, 0.0f));
                this.m_21573_().m_26519_(this.m_20185_() + $$6.f_82479_, this.m_20186_() + $$6.f_82480_, this.m_20189_() + $$6.f_82481_, this.m_5823_());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="stdrive", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CarHandler {
        public static final List<Class<?>> PROHIBITED_USE_CLASSES = List.of(CrossbowItem.class, BowItem.class, FishingRodItem.class, FuelCanisterItem.class);

        @SubscribeEvent
        public static void useItem(LivingEntityUseItemEvent.Start event) {
            if (event.getEntity().m_20202_() instanceof STCarEntity) {
                Item item = event.getItem().m_41720_();
                if (PROHIBITED_USE_CLASSES.stream().anyMatch(clazz -> clazz.isInstance(item))) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

