/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.entities.car;

import com.storyteam.carmod.content.entities.car.STCarEntity;
import com.storyteam.carmod.content.entities.car.SpecialPaint;
import com.storyteam.carmod.util.STCarUtil;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.zeith.hammerlib.api.io.IAutoNBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializable;

public class CarPaint
implements IAutoNBTSerializable {
    public static final CarPaint[] DEFAULT = new CarPaint[]{new CarPaint(6319615), new CarPaint(3684438), new CarPaint(16746077), new CarPaint(6488016), new CarPaint(13090781), new CarPaint(11206508), new CarPaint(3455487), new CarPaint(0xF0F3FF), new CarPaint(16746588), new CarPaint(16738975), new CarPaint(0xA555FF), new CarPaint(16727269), new CarPaint(16726093), new CarPaint(16761370)};
    @NBTSerializable
    private float r;
    @NBTSerializable
    private float g;
    @NBTSerializable
    private float b;
    @NBTSerializable
    private SpecialPaint specialPaint = SpecialPaint.NO;

    public CarPaint(CarPaint carPaint) {
        this.r = carPaint.r;
        this.g = carPaint.g;
        this.b = carPaint.b;
        this.specialPaint = carPaint.getSpecialPaint();
    }

    public CarPaint(SpecialPaint specialPaint, float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.specialPaint = specialPaint;
    }

    public CarPaint(SpecialPaint specialPaint, float c, float m, float y, float k) {
        float[] rgb = STCarUtil.CMYKtoRGB(c, m, y, k);
        this.r = rgb[0];
        this.g = rgb[1];
        this.b = rgb[2];
        this.specialPaint = specialPaint;
    }

    public CarPaint(float c, float m, float y, float k) {
        this(SpecialPaint.NO, c, m, y, k);
    }

    public CarPaint(float r, float g, float b) {
        this(SpecialPaint.NO, r, g, b);
    }

    public CarPaint(int r, int g, int b) {
        this(SpecialPaint.NO, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public CarPaint(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public ResourceLocation getSpecialPaintTexture(EntityType<? extends STCarEntity> carType) {
        return SpecialPaint.getSpecialPaintTexture(carType, this.specialPaint);
    }

    public SpecialPaint getSpecialPaint() {
        return this.specialPaint;
    }

    public float getB() {
        return this.b;
    }

    public float getG() {
        return this.g;
    }

    public float getR() {
        return this.r;
    }

    public static CarPaint getRandomDefaultPaint(Random random) {
        return DEFAULT[random.nextInt(DEFAULT.length)];
    }

    public CarPaint combineWith(CarPaint other) {
        if (this.getSpecialPaint() == SpecialPaint.NO && other.getSpecialPaint() == SpecialPaint.NO) {
            float[] cmyk1 = STCarUtil.RGBtoCMYK(this.r, this.g, this.b);
            float[] cmyk2 = STCarUtil.RGBtoCMYK(other.r, other.g, other.b);
            cmyk1[0] = Math.min(1.0f, cmyk1[0] * 0.5f + cmyk2[0] * 0.5f);
            cmyk1[1] = Math.min(1.0f, cmyk1[1] * 0.5f + cmyk2[1] * 0.5f);
            cmyk1[2] = Math.min(1.0f, cmyk1[2] * 0.5f + cmyk2[2] * 0.5f);
            cmyk1[3] = Math.min(1.0f, cmyk1[3] * 0.5f + cmyk2[3] * 0.5f);
            float[] rgb = STCarUtil.CMYKtoRGB(cmyk1[0], cmyk1[1], cmyk1[2], cmyk1[3]);
            return new CarPaint(SpecialPaint.NO, rgb[0], rgb[1], rgb[2]);
        }
        return other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarPaint carPaint = (CarPaint)o;
        return Float.compare(this.r, carPaint.r) == 0 && Float.compare(this.g, carPaint.g) == 0 && Float.compare(this.b, carPaint.b) == 0 && this.specialPaint == carPaint.specialPaint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), this.specialPaint});
    }
}

