/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.entities.car;

import com.storyteam.carmod.content.entities.car.CarMovementOptions;
import com.storyteam.carmod.content.entities.car.STCarEntity;
import net.minecraft.util.Mth;

public class CarMovement {
    public CarMovementOptions options;
    public float currentSpeed = 0.0f;
    public float currentRotationSpeed = 0.0f;
    public STCarEntity car;
    private float previouszza = 0.0f;
    private float previousxxa = 0.0f;
    private Runnable onStartMovingForward = () -> {};
    private Runnable onStartMovingBackward = () -> {};
    private Runnable onStartTurningLeft = () -> {};
    private Runnable onStartTurningRight = () -> {};
    private Runnable onStopTurning = () -> {};
    private Runnable onBrakes = () -> {};

    public CarMovement(STCarEntity car, CarMovementOptions options) {
        this.options = options;
        this.car = car;
    }

    public void hitBrakes() {
        if (this.currentSpeed != 0.0f) {
            this.onBrakes.run();
            this.currentSpeed = 0.0f;
        }
    }

    public void tick(float xxa, float zza) {
        if (!this.car.isTurnedOn()) {
            xxa = 0.0f;
            zza = 0.0f;
        }
        float minRotation = -this.options.getRotationMaxSpeed();
        float maxRotation = this.options.getRotationMaxSpeed();
        if (xxa > 0.0f) {
            if (this.previousxxa <= 0.0f) {
                this.onStartTurningLeft.run();
            }
            this.currentRotationSpeed = Mth.m_14036_((float)(this.currentRotationSpeed + this.options.getRotationAcceleration()), (float)minRotation, (float)maxRotation);
        } else if (xxa < 0.0f) {
            if (this.previousxxa >= 0.0f) {
                this.onStartTurningRight.run();
            }
            this.currentRotationSpeed = Mth.m_14036_((float)(this.currentRotationSpeed - this.options.getRotationAcceleration()), (float)minRotation, (float)maxRotation);
        } else {
            if (this.previousxxa != 0.0f) {
                this.onStopTurning.run();
            }
            this.currentRotationSpeed = this.currentRotationSpeed > 0.0f ? Mth.m_14036_((float)(this.currentRotationSpeed - this.options.getRotationAcceleration()), (float)0.0f, (float)maxRotation) : Mth.m_14036_((float)(this.currentRotationSpeed + this.options.getRotationAcceleration()), (float)minRotation, (float)0.0f);
        }
        float minSpeed = -this.options.getMaxSpeed(this.car);
        float maxSpeed = this.options.getMaxSpeed(this.car);
        float acceleration = this.options.getAcceleration();
        float p2 = this.options.getMaxSpeed(this.car) * 0.1f;
        if (Math.abs(this.currentSpeed) > p2) {
            acceleration = this.options.getAcceleration() * (1.0f - this.getCarRotationPercent());
        }
        if (zza > 0.0f) {
            if (this.previouszza <= 0.0f) {
                this.onStartMovingForward.run();
            }
            if (this.previouszza < 0.0f || this.previouszza == 0.0f && Math.abs(this.currentSpeed) > 0.0f) {
                this.currentSpeed = Mth.m_14036_((float)(this.currentSpeed + Math.abs(this.currentSpeed) * this.options.getChangeMoveDirectionEfficiency()), (float)minSpeed, (float)maxSpeed);
            }
            this.currentSpeed = Mth.m_14036_((float)(this.currentSpeed + acceleration), (float)minSpeed, (float)maxSpeed);
        } else if (zza < 0.0f) {
            if (this.previouszza >= 0.0f) {
                this.onStartMovingBackward.run();
            }
            if (this.previouszza > 0.0f || this.previouszza == 0.0f && Math.abs(this.currentSpeed) > 0.0f) {
                this.currentSpeed = Mth.m_14036_((float)(this.currentSpeed - this.currentSpeed * this.options.getChangeMoveDirectionEfficiency()), (float)minSpeed, (float)maxSpeed);
            }
            this.currentSpeed = Mth.m_14036_((float)(this.currentSpeed - acceleration), (float)minSpeed, (float)maxSpeed);
        } else {
            this.currentSpeed = this.currentSpeed > 0.0f ? Mth.m_14036_((float)(this.currentSpeed - acceleration), (float)0.0f, (float)maxSpeed) : Mth.m_14036_((float)(this.currentSpeed + acceleration), (float)minSpeed, (float)0.0f);
        }
        this.previouszza = zza;
        this.previousxxa = xxa;
        float p = this.getSpeedPercent();
        if (p > 0.0f) {
            p = Math.min(1.0f, Math.abs(this.currentSpeed) / p2);
        } else if (p < 0.0f) {
            p = -Math.min(1.0f, Math.abs(this.currentSpeed) / p2);
        }
        float yRot = this.car.m_146908_() - this.currentRotationSpeed * p;
        this.car.m_146922_(yRot);
        this.car.m_5618_(yRot);
    }

    private float getCarRotationPercent() {
        return Math.abs(this.currentRotationSpeed) / this.options.getRotationMaxSpeed();
    }

    public void setBrakesListener(Runnable onBrakes) {
        this.onBrakes = onBrakes;
    }

    public void setMovingListeners(Runnable onMoveForward, Runnable onMoveBackward) {
        this.onStartMovingForward = onMoveForward;
        this.onStartMovingBackward = onMoveBackward;
    }

    public void setTurningListeners(Runnable onTurningLeft, Runnable onTurningRight, Runnable onStopTurning) {
        this.onStartTurningLeft = onTurningLeft;
        this.onStartTurningRight = onTurningRight;
        this.onStopTurning = onStopTurning;
    }

    public float getSpeedPercent() {
        return this.currentSpeed / this.options.getMaxSpeed(this.car);
    }
}

