/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.client;

import com.storyteam.carmod.content.client.CarSoundInstance;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="stdrive", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CarLoopingSoundSystem {
    public static final HashMap<UUID, HashMap<SoundEvent, CarSoundInstance>> sounds = new HashMap();

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        CarLoopingSoundSystem.clearEndedSounds();
        CarLoopingSoundSystem.clearEmptySounds();
    }

    private static void clearEndedSounds() {
        for (HashMap<SoundEvent, CarSoundInstance> val : sounds.values()) {
            Iterator<Map.Entry<SoundEvent, CarSoundInstance>> iterator = val.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<SoundEvent, CarSoundInstance> pair = iterator.next();
                CarSoundInstance carSoundInstance = pair.getValue();
                SoundManager soundManager = Minecraft.m_91087_().m_91106_();
                if (soundManager.m_120403_((SoundInstance)carSoundInstance)) continue;
                iterator.remove();
            }
        }
    }

    private static void clearEmptySounds() {
        Iterator<Map.Entry<UUID, HashMap<SoundEvent, CarSoundInstance>>> iterator = sounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, HashMap<SoundEvent, CarSoundInstance>> pair = iterator.next();
            HashMap<SoundEvent, CarSoundInstance> map = pair.getValue();
            if (!map.isEmpty()) continue;
            iterator.remove();
        }
    }

    public static void updateLoopingSoundWorldPosition(UUID soundUUID, SoundEvent soundEvent, Vec3 pos) {
        HashMap<SoundEvent, CarSoundInstance> map;
        if (sounds.containsKey(soundUUID) && (map = sounds.get(soundUUID)).containsKey(soundEvent)) {
            SoundEngine soundEngine = Minecraft.m_91087_().m_91106_().f_120349_;
            Map instToChannel = soundEngine.f_120226_;
            CarSoundInstance carSoundInstance = map.get(soundEvent);
            if (instToChannel.containsKey((Object)carSoundInstance)) {
                ChannelAccess.ChannelHandle channelHandle = (ChannelAccess.ChannelHandle)instToChannel.get((Object)carSoundInstance);
                channelHandle.m_120154_(channel -> {
                    if (carSoundInstance.m_7772_() != 0.0 && carSoundInstance.m_7780_() != 0.0 && carSoundInstance.m_7778_() != 0.0) {
                        channel.m_83654_(pos);
                    }
                });
            }
        }
    }

    public static void removeLoopingSound(UUID soundUUID, SoundEvent soundEvent) {
        HashMap<SoundEvent, CarSoundInstance> map;
        CarSoundInstance carSoundInstance;
        if (sounds.containsKey(soundUUID) && (carSoundInstance = (map = sounds.get(soundUUID)).get(soundEvent)) != null) {
            map.remove(soundEvent);
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            soundManager.m_120399_((SoundInstance)carSoundInstance);
        }
    }

    public static void addLoopingSound(CarSoundInstance carSoundInstance) {
        UUID uuid = carSoundInstance.getUUID();
        SoundEvent soundEvent = carSoundInstance.getSoundEvent();
        carSoundInstance.setLooping(true);
        HashMap map = sounds.computeIfAbsent(uuid, u -> new HashMap());
        if (!map.containsKey(soundEvent)) {
            map.put(soundEvent, carSoundInstance);
            SoundManager soundManager = Minecraft.m_91087_().m_91106_();
            soundManager.m_120367_((SoundInstance)carSoundInstance);
        }
    }
}

