/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.content.blocks;

import com.storyteam.carmod.content.blockentities.GarageDoorTileEntity;
import com.storyteam.carmod.init.STCarBlockEntities;
import com.storyteam.carmod.init.STCarBlocks;
import com.storyteam.carmod.init.STCarSounds;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GarageDoorBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final int HEIGHT = 3;
    public static final BooleanProperty MAIN_BLOCK = BooleanProperty.m_61465_((String)"main");
    public static final BooleanProperty OPENED = BooleanProperty.m_61465_((String)"opened");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public GarageDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)MAIN_BLOCK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)MAIN_BLOCK)).booleanValue()) {
            return super.m_7898_(state, level, pos);
        }
        return super.m_7898_(state, level, pos) && level.m_8055_(pos.m_7495_()).m_60734_() instanceof GarageDoorBlock;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState other, LevelAccessor level, BlockPos pos, BlockPos updatePos) {
        level.m_186460_(pos, (Block)this, 1);
        return super.m_7417_(state, dir, other, level, pos, updatePos);
    }

    public void m_6861_(BlockState p_60509_, Level level, BlockPos pos, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        level.m_186460_(pos, (Block)this, 1);
        super.m_6861_(p_60509_, level, pos, p_60512_, p_60513_, p_60514_);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        AtomicBoolean shouldBePowered = new AtomicBoolean();
        AtomicBoolean isPowered = new AtomicBoolean();
        this.visitDoors((Level)level, pos, (lev, ps, st, offset) -> {
            if (!shouldBePowered.get() && lev.m_276867_(ps)) {
                shouldBePowered.set(true);
            }
            if (!isPowered.get() && ((Boolean)st.m_61143_((Property)POWERED)).booleanValue()) {
                isPowered.set(true);
            }
        });
        if (shouldBePowered.get() != isPowered.get()) {
            boolean power = shouldBePowered.get();
            this.visitDoors((Level)level, pos, (lev, ps, st, offset) -> lev.m_46597_(ps, (BlockState)((BlockState)st.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(power))).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(power))));
            level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), STCarSounds.GARAGE_DOOR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            BlockPos p = GarageDoorBlock.getMainBlockPos(level, pos);
            if (p == null) {
                super.m_5707_(level, pos, state, player);
            } else {
                for (int i = 2; i >= 0; --i) {
                    BlockPos destroyPos = p.m_6630_(i);
                    if (pos.equals((Object)destroyPos)) continue;
                    level.m_46961_(destroyPos, false);
                }
            }
            Vec3 center = pos.m_252807_();
            if (!player.m_150110_().f_35937_) {
                ItemEntity item = new ItemEntity(level, center.f_82479_, center.f_82480_, center.f_82481_, new ItemStack((ItemLike)STCarBlocks.GARAGE_DOOR));
                level.m_7967_((Entity)item);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public static BlockPos getMainBlockPos(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof GarageDoorBlock)) {
            return null;
        }
        BlockPos p = pos;
        while (true) {
            BlockState state1;
            if (!((state1 = level.m_8055_(p)).m_60734_() instanceof GarageDoorBlock)) {
                return null;
            }
            if (((Boolean)state1.m_61143_((Property)MAIN_BLOCK)).booleanValue()) break;
            p = p.m_7495_();
        }
        return p;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        for (int i = 1; i < 3; ++i) {
            BlockState above = level.m_8055_(pos.m_6630_(i));
            if (above.m_60629_(context)) continue;
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        for (int i = 1; i < 3; ++i) {
            level.m_7731_(pos.m_6630_(i), (BlockState)state.m_61124_((Property)MAIN_BLOCK, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            BlockPos main = GarageDoorBlock.getMainBlockPos(level, pos);
            if (main == null) {
                return InteractionResult.PASS;
            }
            boolean next = (Boolean)level.m_8055_(pos).m_61143_((Property)OPENED) == false;
            this.setOpened(level, pos, next);
            level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), STCarSounds.GARAGE_DOOR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void setOpened(Level level, BlockPos pos, boolean state) {
        this.visitDoors(level, pos, (lev, offpos, st, h) -> lev.m_7731_(offpos, (BlockState)st.m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(state)), 3));
    }

    public void visitDoors(Level level, BlockPos pos, DoorVisitor visitor) {
        BlockPos mainPos = GarageDoorBlock.getMainBlockPos(level, pos);
        if (mainPos == null) {
            return;
        }
        BlockState main = level.m_8055_(mainPos);
        for (int h = 0; h < 3; ++h) {
            BlockState st1 = level.m_8055_(mainPos.m_6630_(h));
            visitor.accept(level, mainPos.m_6630_(h), st1, h);
        }
        Direction direction = (Direction)main.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Direction d1 = direction.m_122427_();
        int maxOpenLength = 6;
        for (int mul = -1; mul <= 1; mul += 2) {
            BlockPos offspos;
            BlockState st;
            for (int i = 1; i < maxOpenLength && (st = level.m_8055_(offspos = mainPos.m_5484_(d1, i * mul))).m_60734_() instanceof GarageDoorBlock && ((Boolean)st.m_61143_((Property)MAIN_BLOCK)).booleanValue() && st.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == direction; ++i) {
                for (int h = 0; h < 3; ++h) {
                    BlockState st1 = level.m_8055_(offspos.m_6630_(h));
                    visitor.accept(level, offspos.m_6630_(h), st1, h);
                }
            }
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)MAIN_BLOCK)).booleanValue()) {
            return null;
        }
        return STCarBlockEntities.GARAGE_DOOR.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_) {
            return null;
        }
        return (level1, pos, state1, blockEntity) -> GarageDoorTileEntity.tick(level, (GarageDoorTileEntity)blockEntity, pos, state1);
    }

    public RenderShape m_7514_(BlockState state) {
        if (!((Boolean)state.m_61143_((Property)MAIN_BLOCK)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
        builder.m_61104_(new Property[]{OPENED});
        builder.m_61104_(new Property[]{MAIN_BLOCK});
        builder.m_61104_(new Property[]{POWERED});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPENED)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, context);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case WEST: 
            case EAST: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public static interface DoorVisitor {
        public void accept(Level var1, BlockPos var2, BlockState var3, int var4);
    }
}

