/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod.client.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.storyteam.carmod.STDrive;
import com.storyteam.carmod.content.entities.car.STCarEntity;
import com.storyteam.carmod.content.items.FuelCanisterItem;
import com.storyteam.carmod.init.STCarItems;
import com.storyteam.carmod.util.STCarRenderUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT}, modid="stdrive")
public class FuelOverlay
implements IGuiOverlay {
    private static float previousFuel = 0.0f;
    private static float targetFuel = 0.0f;
    private static float currentFuel = 0.0f;
    private static boolean wasRenderingFuel = false;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        previousFuel = currentFuel;
        if (currentFuel != targetFuel) {
            currentFuel = targetFuel > currentFuel ? Mth.m_14036_((float)(currentFuel + 5.0f), (float)0.0f, (float)targetFuel) : Mth.m_14036_((float)(currentFuel - 5.0f), (float)targetFuel, (float)2.1474836E9f);
        }
    }

    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float pticks, int w, int h) {
        Font font = Minecraft.m_91087_().f_91062_;
        Window window = Minecraft.m_91087_().m_91268_();
        int width = window.m_85445_();
        int height = window.m_85446_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ResourceLocation fuelTexture = STDrive.location("textures/gui/fuel/fuel.png");
        int texWidth = 64;
        int texHeight = 31;
        float scale = 0.8f;
        int offset = (int)((float)height - 75.0f * scale) - 1;
        int offsetX = (int)((float)(width / 2) - (float)(texWidth / 2) * scale);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        Item item = player.m_21205_().m_41720_();
        boolean renderFuel = false;
        float fuel = 0.0f;
        float max = 0.0f;
        Entity entity = player.m_20202_();
        if (entity instanceof STCarEntity) {
            STCarEntity car = (STCarEntity)entity;
            fuel = car.getFuel();
            max = car.getMaxFuel();
            renderFuel = true;
        } else if (item instanceof FuelCanisterItem || item == STCarItems.APOCALYPSE_CAR_KEYS) {
            HitResult result = Minecraft.m_91087_().f_91077_;
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                Entity entity2 = entityHitResult.m_82443_();
                if (entity2 instanceof STCarEntity) {
                    STCarEntity car = (STCarEntity)entity2;
                    fuel = car.getFuel();
                    max = car.getMaxFuel();
                    renderFuel = true;
                }
            } else {
                wasRenderingFuel = false;
            }
        } else {
            wasRenderingFuel = false;
        }
        if (renderFuel) {
            if (!wasRenderingFuel) {
                currentFuel = fuel;
                previousFuel = fuel;
            }
            wasRenderingFuel = true;
            targetFuel = fuel;
            float fuelToRender = Mth.m_14179_((float)pticks, (float)previousFuel, (float)currentFuel);
            guiGraphics.m_280653_(font, (Component)Component.m_237115_((String)"stdrive.word.fuel"), (int)(((float)width / 2.0f + (float)offsetX) / scale), (int)((float)offset / scale), 0xFFFFFF);
            String string = "%d/".formatted(Math.round(fuelToRender)) + Math.round(max);
            int n = (int)(((float)width / 2.0f + (float)offsetX) / scale);
            Objects.requireNonNull(font);
            guiGraphics.m_280137_(font, string, n, (int)((float)(offset + 9) / scale), 0xFFFFFF);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)fuelTexture);
            STCarRenderUtil.blitWithBlend(guiGraphics.m_280168_(), ((float)width / 2.0f + (float)offsetX) / scale - (float)texWidth / 2.0f - 1.0f, (float)offset / scale - 6.0f, texWidth, texHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

