/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod;

import com.mojang.datafixers.util.Pair;
import com.storyteam.carmod.STDrive;
import com.storyteam.carmod.init.STCarItems;
import com.storyteam.carmod.init.STCarVillagerProfessions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.zeith.hammerlib.util.mcf.Resources;

@Mod.EventBusSubscriber(modid="stdrive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class STCarEvents {
    public static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)STDrive.location("empty"));

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() != STCarVillagerProfessions.CAR_MASTER) {
            return;
        }
        Int2ObjectMap trades = event.getTrades();
        ((List)trades.get(1)).addAll(List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.f_42413_, 15, 16, 2), new VillagerTrades.ItemsForEmeralds(Items.f_42416_, 1, 3, 12, 1), new VillagerTrades.ItemsForEmeralds(Items.f_151052_, 1, 1, 12, 1), new VillagerTrades.ItemsForEmeralds(Items.f_42417_, 1, 2, 12, 1)));
        ((List)trades.get(2)).addAll(List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.f_42416_, 4, 12, 10), new VillagerTrades.EmeraldForItems((ItemLike)Items.f_151052_, 2, 12, 10), new VillagerTrades.EmeraldForItems((ItemLike)Items.f_42417_, 3, 12, 10)));
        ((List)trades.get(3)).addAll(List.of(new VillagerTrades.ItemsForEmeralds(STCarItems.FUEL_CANISTER.m_7968_(), 10, 1, 10, 12, 0.25f)));
        ((List)trades.get(4)).addAll(List.of(new VillagerTrades.ItemsForEmeralds(STCarItems.REPAIR_KIT.m_7968_(), 24, 1, 10, 12, 0.25f)));
        ((List)trades.get(5)).addAll(List.of(new VillagerTrades.ItemsForEmeralds(STCarItems.APOCALYPSE_CAR_KEYS.m_7968_(), 48, 1, 1, 12, 0.25f)));
    }

    @SubscribeEvent
    public static void serverAboutToStart(ServerAboutToStartEvent event) {
        STCarEvents.addBuildingToPool(event, EMPTY_PROCESSOR_LIST, "stdrive:garageplains", 120, Resources.location((String)"village/plains/houses"));
        STCarEvents.addBuildingToPool(event, EMPTY_PROCESSOR_LIST, "stdrive:garagesavanna", 120, Resources.location((String)"village/savanna/houses"));
        STCarEvents.addBuildingToPool(event, EMPTY_PROCESSOR_LIST, "stdrive:garagesnow", 120, Resources.location((String)"village/snowy/houses"));
        STCarEvents.addBuildingToPool(event, EMPTY_PROCESSOR_LIST, "stdrive:garagetaiga", 120, Resources.location((String)"village/taiga/houses"));
        STCarEvents.addBuildingToPool(event, EMPTY_PROCESSOR_LIST, "stdrive:garagedesert", 120, Resources.location((String)"village/desert/houses"));
    }

    public static void addBuildingToPool(ServerAboutToStartEvent event, ResourceKey<StructureProcessorList> processorListResourceKey, String nbtLocation, int weight, ResourceLocation pool) {
        MinecraftServer server = event.getServer();
        Registry templatePools = server.m_206579_().m_175515_(Registries.f_256948_);
        Registry structureProcessorLists = server.m_206579_().m_175515_(Registries.f_257011_);
        STCarEvents.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)structureProcessorLists, pool, processorListResourceKey, nbtLocation, weight);
    }

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorsRegistry, ResourceLocation poolLocation, ResourceKey<StructureProcessorList> processorListKey, String nbtLocation, int weight) {
        StructureTemplatePool pool = templatePoolRegistry.m_6612_(poolLocation).orElse(null);
        Holder.Reference list = processorsRegistry.m_246971_(processorListKey);
        if (pool == null) {
            throw new RuntimeException("Pool not found: " + poolLocation);
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtLocation, (Holder)list).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }
}

