/*
 * Decompiled with CFR 0.152.
 */
package com.storyteam.carmod;

import com.mojang.blaze3d.platform.InputConstants;
import com.storyteam.carmod.client.overlay.FuelOverlay;
import com.storyteam.carmod.content.entities.car.CarPaint;
import com.storyteam.carmod.content.entities.renderers.ApocalypseCarRenderer;
import com.storyteam.carmod.content.items.SprayPaintItem;
import com.storyteam.carmod.init.STCarEntities;
import com.storyteam.carmod.init.STCarItems;
import com.storyteam.carmod.util.STCarUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="stdrive", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class STCarClientModEvents {
    public static final KeyMapping OPEN_BOOSTY_SCREEN = new KeyMapping("stdrive.key.open_boosty_screen", InputConstants.Type.KEYSYM, 74, "key.stdrive.keys");
    public static final KeyMapping TRIGGER_CAR_STOP = new KeyMapping("stdrive.key.trigger_car_stop", InputConstants.Type.KEYSYM, 32, "key.stdrive.keys");

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_BOOSTY_SCREEN);
    }

    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerColorHandlersEvent(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                if (!SprayPaintItem.hasPaint(stack)) {
                    return 0xFFFFFF;
                }
                CarPaint carPaint = SprayPaintItem.getCarPaint(stack);
                int col = STCarUtil.packRGB(carPaint.getR(), carPaint.getG(), carPaint.getB());
                return col -= 0x1000000;
            }
            return -1;
        }, new ItemLike[]{STCarItems.SPRAY_PAINT});
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(STCarEntities.APOCALYPSE_CAR, ApocalypseCarRenderer::new);
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "fuel_overlay", (IGuiOverlay)new FuelOverlay());
    }
}

