/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.zeith.hammerlib.api.io.ICompoundSerializable;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class SerializableMethodHandle
implements ICompoundSerializable {
    protected Method method;
    protected Object instance;
    protected Object[] args;
    protected boolean resolved;

    public SerializableMethodHandle(Method method, Object instance, Object ... args) {
        this.method = method;
        this.instance = method == null || Modifier.isStatic(method.getModifiers()) ? null : instance;
        this.args = args;
        this.updateResolution();
    }

    public SerializableMethodHandle(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.updateResolution();
    }

    public void setInstance(Object instance) {
        this.instance = instance;
        this.updateResolution();
    }

    public void setArgs(Object[] args) {
        this.args = args;
        this.updateResolution();
    }

    public static SerializableMethodHandle create(Class<?> owner, String methodName, Object instance, Object ... args) {
        int al = args.length;
        List<Method> res = Arrays.stream(owner.getMethods()).filter(m -> m.getName().equals(methodName) && m.getParameterCount() == al).toList();
        Method resolved = null;
        block0: for (Method candidate : res) {
            Class<?>[] pars = candidate.getParameterTypes();
            for (int i = 0; i < al; ++i) {
                if ((args[i] != null || pars[i].isPrimitive()) && !pars[i].isInstance(args[i])) continue block0;
            }
            resolved = candidate;
            break;
        }
        return new SerializableMethodHandle(resolved, instance, args);
    }

    public void updateResolution() {
        boolean resolved;
        boolean bl = resolved = this.method != null && (this.instance != null || Modifier.isStatic(this.method.getModifiers())) && this.args != null && this.args.length == this.method.getParameterCount();
        if (!resolved) {
            this.resolved = false;
            return;
        }
        Class<?>[] args = this.method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isInstance(this.args[i])) continue;
            this.resolved = false;
            return;
        }
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public Object call() throws MethodHandleInvocationException {
        try {
            return this.method.invoke(this.instance, this.args);
        }
        catch (Exception e) {
            throw new MethodHandleInvocationException(e);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Class", this.method.getDeclaringClass().getCanonicalName());
        nbt.m_128359_("Method", this.method.getName());
        if (!ReflectionUtil.isUniqueMethod(this.method)) {
            ListTag pars = new ListTag();
            for (Class<?> type : this.method.getParameterTypes()) {
                pars.add((Object)StringTag.m_129297_((String)type.getCanonicalName()));
            }
            nbt.m_128365_("Types", (Tag)pars);
        }
        if (this.instance != null) {
            NBTSerializationHelper.serializeField(this.instance.getClass(), this.instance, nbt, "Instance");
        }
        nbt.m_128405_("Args", this.args.length);
        for (int i = 0; i < this.args.length; ++i) {
            Object arg = this.args[i];
            NBTSerializationHelper.serializeField(arg.getClass(), arg, nbt, "Arg" + i);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int i;
        Method resolved;
        Class cls;
        block12: {
            this.method = null;
            this.instance = null;
            this.args = new Object[0];
            this.resolved = false;
            cls = ReflectionUtil.fetchClass(nbt.m_128461_("Class"));
            if (cls == null) {
                return;
            }
            String mName = nbt.m_128461_("Method");
            List<Method> res = Arrays.stream(cls.getMethods()).filter(m -> m.getName().equals(mName)).toList();
            if (res.isEmpty()) {
                return;
            }
            resolved = null;
            if (nbt.m_128425_("Types", 9)) {
                ListTag typesNbt = nbt.m_128437_("Types", 8);
                Class[] args = new Class[typesNbt.size()];
                for (i = 0; i < typesNbt.size(); ++i) {
                    Class a = ReflectionUtil.fetchClass(typesNbt.m_128778_(i));
                    if (a != null) {
                        args[i] = a;
                        continue;
                    }
                    break block12;
                }
                block1: for (Method t : res) {
                    Class<?>[] types = t.getParameterTypes();
                    if (types.length != args.length) continue;
                    for (int i2 = 0; i2 < types.length; ++i2) {
                        if (!args[i2].equals(types[i2])) continue block1;
                    }
                    resolved = t;
                    break;
                }
            } else if (res.size() <= 1) {
                resolved = res.get(0);
            }
        }
        if (resolved == null) {
            return;
        }
        this.method = resolved;
        if (nbt.m_128425_("Instance", 10)) {
            this.instance = NBTSerializationHelper.deserializeField(cls, nbt, "Instance");
        }
        this.args = new Object[nbt.m_128451_("Args")];
        Class<?>[] pars = this.method.getParameterTypes();
        int c = Math.min(this.args.length, pars.length);
        for (i = 0; i < c; ++i) {
            this.args[i] = NBTSerializationHelper.deserializeField(pars[i], nbt, "Arg" + i);
        }
        this.updateResolution();
    }

    public String toString() {
        return "SerializableMethodHandle{resolved=" + this.resolved + ", method=" + this.method + ", instance=" + this.instance + ", args=" + Arrays.toString(this.args) + "}";
    }

    public static class MethodHandleInvocationException
    extends ReflectiveOperationException {
        public MethodHandleInvocationException(Throwable cause) {
            super(cause);
        }
    }
}

