/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java.io.win32;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.function.LongConsumer;
import org.zeith.hammerlib.util.java.io.win32.ZoneIdentifier;

public final class ZoneIdentifierFile
extends File {
    private final File origin;

    ZoneIdentifierFile(File origin, String parent) {
        super(parent);
        this.origin = origin;
    }

    public File getOrigin() {
        return this.origin;
    }

    public long downloadFile(InputStream input, String websiteUrl, String directUrl) throws IOException {
        long r = Files.copy(input, this.origin.toPath(), StandardCopyOption.REPLACE_EXISTING);
        ZoneIdentifier id = new ZoneIdentifier();
        id.zoneId = 3;
        id.referrerUrl = websiteUrl;
        id.hostUrl = directUrl;
        this.set(id);
        return r;
    }

    public void downloadFile(InputStream input, String websiteUrl, String directUrl, LongConsumer bytesDownloaded) throws IOException {
        Files.deleteIfExists(this.origin.toPath());
        try (OutputStream output = Files.newOutputStream(this.origin.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            int n;
            long nread = 0L;
            byte[] buf = new byte[8192];
            while ((n = input.read(buf)) > 0) {
                output.write(buf, 0, n);
                bytesDownloaded.accept(nread += (long)n);
            }
        }
        ZoneIdentifier id = new ZoneIdentifier();
        id.zoneId = 3;
        id.referrerUrl = websiteUrl;
        id.hostUrl = directUrl;
        this.set(id);
    }

    public void set(String websiteUrl, String directUrl) throws IOException {
        ZoneIdentifier id = new ZoneIdentifier();
        id.zoneId = 3;
        id.referrerUrl = websiteUrl;
        id.hostUrl = directUrl;
        this.set(id);
    }

    public boolean set(ZoneIdentifier id) throws IOException {
        if (this.origin.isFile()) {
            boolean bl;
            BufferedWriter writer = new BufferedWriter(new FileWriter(this));
            try {
                id.write(writer);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return false;
                }
            }
            writer.close();
            return bl;
        }
        return false;
    }
}

