/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.util.NoSuchElementException;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import lombok.Generated;
import org.zeith.hammerlib.util.java.itf.BooleanConsumer;

public enum OptionalBoolean {
    EMPTY(false, false),
    OPTIONAL_FALSE(true, false),
    OPTIONAL_TRUE(true, true);

    private final boolean present;
    private final boolean value;

    private OptionalBoolean(boolean present, boolean value) {
        this.present = present;
        this.value = value;
    }

    public static OptionalBoolean empty() {
        return EMPTY;
    }

    public static OptionalBoolean of(boolean value) {
        return value ? OPTIONAL_TRUE : OPTIONAL_FALSE;
    }

    public boolean isEmpty() {
        return !this.present;
    }

    public boolean getAsBoolean() {
        if (!this.present) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean orElse(boolean other) {
        return this.present ? this.value : other;
    }

    public boolean orElseGet(BooleanSupplier other) {
        return this.present ? this.value : other.getAsBoolean();
    }

    public <X extends Throwable> boolean orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (!this.present) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public boolean orElseThrow() {
        if (!this.present) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public void ifPresent(BooleanConsumer action) {
        if (this.present) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(BooleanConsumer action, Runnable emptyAction) {
        if (this.present) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public OptionalInt toInt() {
        if (this.present) {
            return OptionalInt.of(this.value ? 1 : 0);
        }
        return OptionalInt.empty();
    }

    public String toString() {
        return !this.present ? "empty" : (this.value ? "true" : "false");
    }

    public OptionalBoolean or(OptionalBoolean fallback) {
        return this.isPresent() ? this : fallback;
    }

    @Generated
    public boolean isPresent() {
        return this.present;
    }
}

