/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.client.flowgui.FlowguiShaderRegistry;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.objects.GuiButtonObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiImageObject;

public class GuiSpriteButtonObject
extends GuiButtonObject {
    public ResourceLocation texture;
    public Vec3 color = new Vec3(1.0, 1.0, 1.0);
    public Supplier<ShaderInstance> shader = FlowguiShaderRegistry.GUI_SHADER;
    public int shaderTexture = 0;

    public GuiSpriteButtonObject(@NotNull String name, float alpha, int packedFGColor, boolean enabled, @NotNull Component message, @NotNull GuiButtonObject.OnPress callback, Supplier<SoundEvent> pressSound, Float pressSoundPitch, @NotNull ResourceLocation customTexture, Vec3 color) {
        super(name, alpha, packedFGColor, enabled, message, callback, pressSound, pressSoundPitch);
        this.texture = customTexture;
        if (color != null) {
            this.color = color;
        }
    }

    public GuiSpriteButtonObject shader(Supplier<ShaderInstance> shader) {
        this.shader = shader;
        return this;
    }

    public GuiSpriteButtonObject shaderTexture(int shaderTexture) {
        this.shaderTexture = shaderTexture;
        return this;
    }

    @Override
    protected void renderButtonBg(Graphics gfx, MousePos pos) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        gfx.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        gfx.drawManaged(() -> {
            RenderSystem.setShaderTexture((int)this.shaderTexture, (ResourceLocation)this.texture);
            GuiImageObject.blitWithBlend(this.shader, gfx.gfx(), 0.0f, this.getTextureY(pos.isMouseWithin(this)), this.width, this.height, this.width, this.height * 3.0f, this.alpha, this.color);
        });
        gfx.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    protected int getTextureY(boolean hovered) {
        int state = 1;
        if (!this.enabled) {
            state = 0;
        } else if (hovered) {
            state = 2;
        }
        return (int)((float)state * this.height);
    }

    public static SpriteButtonBuilder of(String name) {
        return new SpriteButtonBuilder().name(name).alpha(1.0f).packedFGColor(-1).enabled(true).message((Component)Component.m_237119_()).callback(GuiButtonObject.OnPress.NONE).pressSound((Supplier<SoundEvent>)SoundEvents.f_12490_);
    }

    @Generated
    public static SpriteButtonBuilder builder() {
        return new SpriteButtonBuilder();
    }

    @Generated
    public static class SpriteButtonBuilder {
        @Generated
        private String name;
        @Generated
        private float alpha;
        @Generated
        private int packedFGColor;
        @Generated
        private boolean enabled;
        @Generated
        private Component message;
        @Generated
        private GuiButtonObject.OnPress callback;
        @Generated
        private Supplier<SoundEvent> pressSound;
        @Generated
        private Float pressSoundPitch;
        @Generated
        private ResourceLocation customTexture;
        @Generated
        private Vec3 color;

        @Generated
        SpriteButtonBuilder() {
        }

        @Generated
        public SpriteButtonBuilder name(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public SpriteButtonBuilder alpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        @Generated
        public SpriteButtonBuilder packedFGColor(int packedFGColor) {
            this.packedFGColor = packedFGColor;
            return this;
        }

        @Generated
        public SpriteButtonBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public SpriteButtonBuilder message(@NotNull Component message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @Generated
        public SpriteButtonBuilder callback(@NotNull GuiButtonObject.OnPress callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this;
        }

        @Generated
        public SpriteButtonBuilder pressSound(Supplier<SoundEvent> pressSound) {
            this.pressSound = pressSound;
            return this;
        }

        @Generated
        public SpriteButtonBuilder pressSoundPitch(Float pressSoundPitch) {
            this.pressSoundPitch = pressSoundPitch;
            return this;
        }

        @Generated
        public SpriteButtonBuilder customTexture(@NotNull ResourceLocation customTexture) {
            if (customTexture == null) {
                throw new NullPointerException("customTexture is marked non-null but is null");
            }
            this.customTexture = customTexture;
            return this;
        }

        @Generated
        public SpriteButtonBuilder color(Vec3 color) {
            this.color = color;
            return this;
        }

        @Generated
        public GuiSpriteButtonObject build() {
            return new GuiSpriteButtonObject(this.name, this.alpha, this.packedFGColor, this.enabled, this.message, this.callback, this.pressSound, this.pressSoundPitch, this.customTexture, this.color);
        }

        @Generated
        public String toString() {
            return "GuiSpriteButtonObject.SpriteButtonBuilder(name=" + this.name + ", alpha=" + this.alpha + ", packedFGColor=" + this.packedFGColor + ", enabled=" + this.enabled + ", message=" + this.message + ", callback=" + this.callback + ", pressSound=" + this.pressSound + ", pressSoundPitch=" + this.pressSoundPitch + ", customTexture=" + this.customTexture + ", color=" + this.color + ")";
        }
    }
}

