/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.util.Tooltip;
import org.zeith.hammerlib.client.render.FluidRendererHelper;
import org.zeith.hammerlib.client.screen.IAdvancedComponent;
import org.zeith.hammerlib.client.utils.FluidTextureType;

public class GuiFluidObject
extends GuiObject
implements IAdvancedComponent {
    public FluidTextureType textureType = FluidTextureType.STILL;
    public Supplier<FluidStack> stack;
    public boolean hoverable;
    public boolean provideIngredient;
    public boolean isMouseOver;
    public int capacity = 1;
    public boolean showCapacity;

    public GuiFluidObject(String name, Supplier<FluidStack> stack) {
        super(name);
        this.size(16.0f, 16.0f);
        this.stack = stack;
    }

    public GuiFluidObject capacity(int capacity) {
        this.capacity = Math.max(1, capacity);
        return this;
    }

    public GuiFluidObject showCapacity(boolean showCapacity) {
        this.showCapacity = showCapacity;
        return this;
    }

    public GuiFluidObject hoverable(boolean hoverable) {
        this.hoverable = hoverable;
        return this;
    }

    public GuiFluidObject provideIngredient(boolean provideIngredient) {
        this.provideIngredient = provideIngredient;
        return this;
    }

    public GuiFluidObject textureType(FluidTextureType textureType) {
        this.textureType = textureType;
        return this;
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        FluidStack stack = this.stack.get();
        if (stack.isEmpty()) {
            return;
        }
        PoseStack pose = gfx.pose();
        FluidRendererHelper.renderFluidInGui(gfx.gfx(), stack, this.textureType, (float)stack.getAmount() / (float)this.capacity, 0.0f, 0.0f, this.width, this.height);
        this.isMouseOver = pos.isMouseWithin(this);
        if (this.hoverable && this.isMouseOver) {
            GuiGraphics g = gfx.gfx();
            pose.m_85836_();
            pose.m_85841_(this.width, this.height, this.width);
            g.m_285978_(RenderType.m_286086_(), 0, 0, 1, 1, -2130706433, -2130706433, 0);
            pose.m_85849_();
            Minecraft mc = Minecraft.m_91087_();
            this.drawTooltip(gfx, pos, mc.f_91062_, Tooltip.ofFluid(stack, this.showCapacity, this.capacity));
        }
    }

    @Override
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.provideIngredient && mouseX >= 0.0 && mouseY >= 0.0 && mouseX < (double)this.width && mouseY < (double)this.height) {
            return this.stack.get();
        }
        return null;
    }
}

