/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.util.java.Cast;

public class EnumNBTSerializer<ET extends Enum<ET>>
implements INBTSerializer<ET> {
    final Class<ET> type;
    final ET[] constants;

    public EnumNBTSerializer(Class<ET> type) {
        this.type = type;
        this.constants = (Enum[])type.getEnumConstants();
    }

    public static EnumNBTSerializer<?> create(Class<? extends Enum<?>> type) {
        return new EnumNBTSerializer((Class)Cast.cast(type));
    }

    @Override
    public void serialize(CompoundTag nbt, String key, @NotNull ET value) {
        if (value != null) {
            nbt.m_128405_(key, ((Enum)value).ordinal());
        }
    }

    @Override
    public ET deserialize(CompoundTag nbt, String key) {
        if (nbt.m_128425_(key, 3)) {
            return this.constants[Math.abs(nbt.m_128451_(key)) % this.constants.length];
        }
        return null;
    }
}

