/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.recipes;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipeType;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.consumers.Consumer2;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class RecipeVisualizationRegistry {
    private final Map<RecipeType<?>, IRecipeVisualizer<?, ?>> VIS_REGISTRY = new ConcurrentHashMap();

    public <T extends Recipe<?>> void register(RecipeType<T> type, IRecipeVisualizer<T, ?> visualizer) {
        this.VIS_REGISTRY.put(type, visualizer);
    }

    public <T extends Recipe<?>> Optional<IRecipeVisualizer<T, ?>> getVisualizer(RecipeType<T> type) {
        return Optional.ofNullable((IRecipeVisualizer)Cast.cast(this.VIS_REGISTRY.get(type)));
    }

    public Stream<RecipeType<?>> getVisualizedRecipeTypes() {
        return this.VIS_REGISTRY.keySet().stream();
    }

    public Stream<Tuple2<RecipeType<?>, IRecipeVisualizer<?, ?>>> getVisualizedEntries() {
        return this.VIS_REGISTRY.entrySet().stream().map(e -> Tuples.immutable((RecipeType)e.getKey(), (IRecipeVisualizer)e.getValue()));
    }

    public void reload() {
        this.VIS_REGISTRY.clear();
        HammerLib.EVENT_BUS.post((Event)new RegisterRecipeVisualizationEvent(this));
        for (RecipeType type : ForgeRegistries.RECIPE_TYPES.getValues()) {
            if (!(type instanceof IVisualizedRecipeType)) continue;
            IVisualizedRecipeType visual = (IVisualizedRecipeType)type;
            AtomicReference visualizer = new AtomicReference();
            visual.initVisuals(visualizer::set);
            IRecipeVisualizer vis = (IRecipeVisualizer)visualizer.get();
            if (vis == null) continue;
            this.register(type, (IRecipeVisualizer)Cast.cast(vis));
        }
    }

    public static class RegisterRecipeVisualizationEvent
    extends Event {
        protected final RecipeVisualizationRegistry registry;

        public RegisterRecipeVisualizationEvent(RecipeVisualizationRegistry registry) {
            this.registry = registry;
        }

        public RecipeVisualizationRegistry registry() {
            return this.registry;
        }

        public <T extends Recipe<?>> void register(RecipeType<T> type, IRecipeVisualizer<T, ?> visualizer) {
            this.registry.register(type, visualizer);
        }
    }

    public static class RegisterIngredientInfoEvent
    extends Event {
        protected final Consumer2<List<ItemStack>, Component[]> stackInfo;
        protected final Consumer2<List<FluidStack>, Component[]> fluidInfo;

        public RegisterIngredientInfoEvent(Consumer2<List<ItemStack>, Component[]> stackInfo, Consumer2<List<FluidStack>, Component[]> fluidInfo) {
            this.stackInfo = stackInfo;
            this.fluidInfo = fluidInfo;
        }

        public <T extends Recipe<?>> void registerStack(ItemStack item, Component ... tooltip) {
            this.stackInfo.accept(List.of(item), tooltip);
        }

        public <T extends Recipe<?>> void registerStacks(List<ItemStack> items, Component ... tooltip) {
            this.stackInfo.accept(items, tooltip);
        }

        public <T extends Recipe<?>> void registerFluid(FluidStack fluid, Component ... tooltip) {
            this.fluidInfo.accept(List.of(fluid), tooltip);
        }

        public <T extends Recipe<?>> void registerFluids(List<FluidStack> fluids, Component ... tooltip) {
            this.fluidInfo.accept(fluids, tooltip);
        }
    }
}

