/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform.utility;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.bivrik.fancytoasts.utility.TextureUV;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GuiContext {
    private final GuiGraphics guiGraphics;
    private final PoseStack stack;

    public GuiContext(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.stack = guiGraphics.m_280168_();
    }

    public PoseStack stack() {
        return this.stack;
    }

    public GuiGraphics guiGraphics() {
        return this.guiGraphics;
    }

    public void push() {
        this.stack.m_85836_();
    }

    public void pop() {
        this.stack.m_85849_();
    }

    public void translate(float x, float y, float z) {
        this.stack.m_252880_(x, y, z);
    }

    public void translate(float x, float y) {
        this.stack.m_252880_(x, y, 0.0f);
    }

    public void rotateAround(float rotation, float ox, float oy) {
        this.stack.m_272245_(Axis.f_252403_.m_252961_(rotation), ox, oy, 0.0f);
    }

    public void scaleAround(float sx, float sy, float ox, float oy) {
        this.stack.m_252880_(ox, oy, 0.0f);
        this.stack.m_85841_(sx, sy, 1.0f);
        this.stack.m_252880_(-ox, -oy, 0.0f);
    }

    public void scaleAround(float scale, float ox, float oy) {
        this.scaleAround(scale, scale, ox, oy);
    }

    public void drawGUITexture(ResourceLocation textureLocation, int x, int y, int width, int height, TextureUV uv, int textureWidth, int textureHeight) {
        this.guiGraphics.m_280163_(textureLocation, x, y, (float)uv.u(), (float)uv.v(), width, height, textureWidth, textureHeight);
    }

    public void drawGUITexture(ResourceLocation textureLocation, int x, int y, int width, int height, TextureUV uv, int textureWidth, int textureHeight, int color) {
        if (color == -1) {
            this.drawGUITexture(textureLocation, x, y, width, height, uv, textureWidth, textureHeight);
            return;
        }
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        this.guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        this.guiGraphics.m_280163_(textureLocation, x, y, (float)uv.u(), (float)uv.v(), width, height, textureWidth, textureHeight);
        this.guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    public void drawGUITexture(ResourceLocation textureLocation, int x, int y, int width, int height, TextureUV uv, int color) {
        this.drawGUITexture(textureLocation, x, y, width, height, uv, 256, 256, color);
    }

    public void drawSprite(ResourceLocation spriteLocation, int x, int y, int width, int height) {
        this.guiGraphics.m_280163_(spriteLocation, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public void fill(int x, int y, int width, int height, int color) {
        this.guiGraphics.m_280509_(x, y, x + width, y + height, color);
    }
}

