/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform.utility;

import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;

public enum FancyToastType {
    TASK("task", -256, -1),
    GOAL("goal", -14483457, -1),
    CHALLENGE("challenge", -377606, -14483457);

    private final String name;
    private final int mainColor;
    private final int secondaryColor;
    private final Component displayName;
    private final Component displayAnnouncement;

    private FancyToastType(String name, int mainColor, int secondaryColor) {
        this.name = name;
        this.mainColor = mainColor;
        this.secondaryColor = secondaryColor;
        this.displayName = Components.of("toast_type." + this.name);
        this.displayAnnouncement = Component.m_237115_((String)("advancements.toast." + this.name));
    }

    public static FancyToastType transferTypes(FrameType frameType) {
        FancyToastType fancyToastType = TASK;
        switch (frameType) {
            case GOAL: {
                fancyToastType = GOAL;
                break;
            }
            case CHALLENGE: {
                fancyToastType = CHALLENGE;
            }
        }
        return fancyToastType;
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Component getDisplayAnnouncement() {
        return this.displayAnnouncement;
    }

    public int getMainColor() {
        return this.mainColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }
}

