/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.Random;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.bivrik.fancytoasts.utility.DefaultUVs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class FancyAdvancementToast {
    private static final int WIDTH = 162;
    private static final int HEIGHT = 70;
    private static final Random random = new Random();
    private FancyToastAnimation animation;
    private ResourceLocation toastSoundId;
    private float volume;
    private SoundManager soundManager;
    private long time;
    private boolean isEnded = false;
    private int playedSoundsCount = 0;

    public FancyAdvancementToast(Minecraft minecraft, ToastDisplayInfo displayInfo, ResourceLocation textureId, ResourceLocation animationId) {
        GeneralConfigData generalConfig = Managers.getConfigManager().getGeneralConfigData();
        if (generalConfig.areSoundsEnabled()) {
            this.soundManager = minecraft.m_91106_();
        }
        AnimationSetup setup = new AnimationSetup(textureId, displayInfo, null, DefaultUVs.BACKGROUND, DefaultUVs.PLAQUE);
        switch (displayInfo.getAdvancementType()) {
            case TASK: {
                setup.setTypeBasedUVs(DefaultUVs.TASK);
                this.volume = generalConfig.getTaskVolume();
                break;
            }
            case GOAL: {
                setup.setTypeBasedUVs(DefaultUVs.GOAL);
                this.volume = generalConfig.getGoalVolume();
                break;
            }
            case CHALLENGE: {
                setup.setTypeBasedUVs(DefaultUVs.CHALLENGE);
                this.volume = generalConfig.getChallengeVolume();
                break;
            }
            default: {
                throw new RuntimeException("Could match correct advancement type");
            }
        }
        this.animation = AnimationRegistry.getAnimation(animationId).get();
        this.animation.setup(setup, minecraft, this.getWidth(), this.getHeight());
        this.toastSoundId = Managers.getConfigManager().getToastConfigData().getSoundIdByType(displayInfo.getAdvancementType());
        Debug.info("Created new fancy advancement toast: {}; texture: {}; animation: {}", displayInfo.getTitle().getString(), textureId, animationId);
    }

    public void draw(GuiGraphics graphics) {
        this.animation.draw(graphics, this.time);
    }

    public void update(long time) {
        this.time = time;
        if (this.time >= (long)this.animation.getDuration()) {
            this.isEnded = true;
        }
        if (this.soundManager != null) {
            int timeInSeconds = (int)(this.time / 50L);
            switch (this.playedSoundsCount) {
                case 0: {
                    this.playSound(SoundEvents.f_12497_, 1.5f);
                    break;
                }
                case 1: {
                    if (timeInSeconds != this.animation.getToastSoundTiming() / 50) break;
                    this.playSound(this.toastSoundId, this.volume);
                    break;
                }
                case 2: {
                    if (timeInSeconds != this.animation.getDuration() / 50 - 10) break;
                    this.playSound(SoundEvents.f_12497_, 1.5f);
                }
            }
        }
    }

    private void playSound(SoundEvent sound, float volume) {
        this.soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)random.nextFloat(0.95f, 1.05f), (float)volume));
        ++this.playedSoundsCount;
    }

    private void playSound(ResourceLocation soundLocation, float volume) {
        this.playSound(SoundEvent.m_262824_((ResourceLocation)soundLocation), volume);
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 70;
    }
}

