/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.bivrik.fancytoasts.client.gui.Slider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class UniversalScreen
extends Screen {
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    protected final Screen parent;

    public UniversalScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
    }

    public void m_7379_() {
        this.toParentScreen();
    }

    protected <T extends GuiEventListener & Renderable> T addFWidget(T widget) {
        this.addFRenderable(widget);
        return (T)super.m_7787_(widget);
    }

    protected <T extends GuiEventListener & Renderable> void removeFWidget(T widget) {
        this.removeFRenderable(widget);
        super.m_169411_(widget);
    }

    protected <T extends Renderable> T addFRenderable(T renderable) {
        this.renderables.add(renderable);
        return renderable;
    }

    protected <T extends Renderable> void removeFRenderable(T renderable) {
        this.renderables.remove(renderable);
    }

    protected void m_169413_() {
        this.renderables.clear();
        super.m_169413_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.drawBackground(guiGraphics);
        this.drawRenderables(guiGraphics, mouseX, mouseY, partialTick);
        this.drawTitle(guiGraphics);
    }

    public void drawBackground(@NotNull GuiGraphics guiGraphics) {
        super.m_280039_(guiGraphics);
    }

    public void drawRenderables(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void toParentScreen() {
        this.openScreen(this.parent);
    }

    protected void openScreen(Screen screen) {
        Objects.requireNonNull(this.f_96541_).m_91152_(screen);
    }

    protected void drawTitle(GuiGraphics guiGraphics) {
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 12, -1);
    }

    protected Button createButton(Component label, Button.OnPress action, int x, int y, int width, int height, Tooltip tooltip) {
        Button.Builder button = Button.m_253074_((Component)label, (Button.OnPress)action);
        if (tooltip != null) {
            button.m_257505_(tooltip);
        }
        return button.m_252987_(x, y, width, height).m_253136_();
    }

    protected Button createButton(Component label, Button.OnPress action, int x, int y, int width, int height) {
        return this.createButton(label, action, x, y, width, height, null);
    }

    protected Button createButton(Component label, Button.OnPress action, int x, int y, Tooltip tooltip) {
        return this.createButton(label, action, x, y, 150, 20, tooltip);
    }

    protected Button createButton(Component label, Button.OnPress action, int x, int y) {
        return this.createButton(label, action, x, y, 150, 20, null);
    }

    protected Slider createSlider(Component label, float initialValue, float maxValue, float threshold, Function<Float, Component> displayer, Consumer<Float> responder, int x, int y, int width, int height, Tooltip tooltip) {
        Slider slider = new Slider(x, y, width, height, label, initialValue, maxValue, threshold).setDisplayer(displayer).setResponder(responder);
        if (tooltip != null) {
            slider.m_257544_(tooltip);
        }
        return slider;
    }

    protected Slider createSlider(Component label, float initialValue, float maxValue, float threshold, Function<Float, Component> displayer, Consumer<Float> responder, int x, int y, Tooltip tooltip) {
        return this.createSlider(label, initialValue, maxValue, threshold, displayer, responder, x, y, 150, 20, tooltip);
    }

    protected Slider createSlider(Component label, float initialValue, float maxValue, Function<Float, Component> displayer, Consumer<Float> responder, int x, int y) {
        return this.createSlider(label, initialValue, maxValue, 0.0f, displayer, responder, x, y, 150, 20, null);
    }

    protected CycleButton<Boolean> createBooleanButton(Component label, boolean initialValue, CycleButton.OnValueChange<Boolean> action, int x, int y, int width, int height, Tooltip tooltip) {
        CycleButton.Builder onOffButton = CycleButton.m_168919_().m_168948_((Object)initialValue);
        if (tooltip != null) {
            onOffButton.m_232498_(value -> tooltip);
        }
        return onOffButton.m_168936_(x, y, width, height, label, action);
    }

    protected CycleButton<Boolean> createBooleanButton(Component label, boolean initialValue, CycleButton.OnValueChange<Boolean> action, int x, int y, Tooltip tooltip) {
        return this.createBooleanButton(label, initialValue, action, x, y, 150, 20, tooltip);
    }

    protected CycleButton<Boolean> createBooleanButton(Component label, boolean initialValue, CycleButton.OnValueChange<Boolean> action, int x, int y) {
        return this.createBooleanButton(label, initialValue, action, x, y, 150, 20, null);
    }
}

