/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.ToastAnchor;
import net.bivrik.fancytoasts.client.config.ToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.gui.IntegerEditBox;
import net.bivrik.fancytoasts.client.gui.Slider;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.GeneralConfigDataEvent;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GeneralConfigScreen
extends UniversalScreen {
    private static final Component TITLE = Components.of("title.general_settings");
    private static final Component RESET_GENERAL_SETTINGS_TITLE = Components.of("title.reset_general_settings");
    private static final Component RESET_GENERAL_SETTINGS_LABEL = Components.of("label.reset_general_settings");
    private static final Component SAVED_LABEL = Components.of("label.saved");
    private static final Component JADE_HIDING = Components.of("gui.jade_hiding");
    private static final Component SOUNDS = Components.of("gui.sounds_enabled");
    private static final Component SCREEN_BEHAVIOR = Components.of("gui.screen_behavior");
    private static final Component TASK_VOLUME = Components.of("gui.task_volume");
    private static final Component GOAL_VOLUME = Components.of("gui.goal_volume");
    private static final Component CHALLENGE_VOLUME = Components.of("gui.challenge_volume");
    private static final Component LOOPS_STRENGTH = Components.of("gui.loops_strength");
    private static final Component LOOPS_SPEED = Components.of("gui.loops_speed");
    private static final Component RESET = Components.of("gui.reset");
    private static final Component ANCHOR = Components.of("gui.anchor");
    private static final Component JADE_HIDING_TOOLTIP = Components.of("tooltip.jade_hiding");
    private static final Component SOUNDS_TOOLTIP = Components.of("tooltip.sounds_enabled");
    private static final Component SCREEN_BEHAVIOR_TOOLTIP = Components.of("tooltip.screen_behavior");
    private static final Component ANCHOR_TOOLTIP = Components.of("tooltip.anchor");
    private static final Component LOOPS_STRENGTH_TOOLTIP = Components.of("tooltip.loops_strength");
    private static final Component LOOPS_SPEED_TOOLTIP = Components.of("tooltip.loops_speed");
    private static final ResourceLocation LIST_BACKGROUND = ResourceLocations.fromMinecraft("textures/gui/menu_list_background.png");
    private GeneralConfigData generalConfigData = Managers.getConfigManager().getGeneralConfigData();
    private boolean isSaved;
    private long savedFeedbackStartTime;
    private Button doneButton;
    private Button backButton;
    private Button resetButton;
    private CycleButton<Boolean> jadeHidingButton;
    private CycleButton<Boolean> soundsEnabledButton;
    private CycleButton<ToastScreenBehavior> toastScreenBehaviorButton;
    private CycleButton<ToastAnchor> toastAnchorButton;
    private Slider loopsStrengthSlider;
    private Slider loopsSpeedSlider;
    private Slider taskVolumeSlider;
    private Slider goalVolumeSlider;
    private Slider challengeVolumeSlider;
    private IntegerEditBox offsetXEditBox;
    private IntegerEditBox offsetYEditBox;

    public GeneralConfigScreen(Screen parent) {
        super(TITLE, parent);
    }

    protected void m_7856_() {
        int xCenter = this.f_96543_ / 2;
        this.backButton = this.addFWidget(this.createButton(CommonComponents.f_130660_, button -> this.toParentScreen(), xCenter - 125 - 4, this.f_96544_ - 20 - 6, 75, 20));
        this.resetButton = this.addFWidget(this.createButton(RESET, button -> this.confirmResetting(), xCenter - 50, this.f_96544_ - 20 - 6, 50, 20));
        this.doneButton = this.addFWidget(this.createButton(CommonComponents.f_130655_, button -> this.done(), xCenter + 4, this.f_96544_ - 20 - 6, 125, 20));
        ListHelper listHelper = new ListHelper(this);
        if (Services.PLATFORM.isModLoaded("jade")) {
            this.jadeHidingButton = listHelper.addWidget(this.createBooleanButton(JADE_HIDING, this.generalConfigData.isJadeHiding(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.generalConfigData.setJadeHiding((boolean)value)), 0, 0, Tooltip.m_257550_((Component)JADE_HIDING_TOOLTIP)));
        }
        this.soundsEnabledButton = listHelper.addWidget(this.createBooleanButton(SOUNDS, this.generalConfigData.areSoundsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.generalConfigData.setSoundsEnabled((boolean)value)), 0, 0, Tooltip.m_257550_((Component)SOUNDS_TOOLTIP)));
        this.toastScreenBehaviorButton = listHelper.addWidget(CycleButton.m_168894_(ToastScreenBehavior::getDisplayName).m_168961_((Object[])ToastScreenBehavior.values()).m_168948_((Object)this.generalConfigData.getToastScreenBehavior()).m_232498_(toastScreenBehavior -> Tooltip.m_257550_((Component)SCREEN_BEHAVIOR_TOOLTIP)).m_168936_(0, 0, 150, 20, SCREEN_BEHAVIOR, (button, value) -> this.generalConfigData.setToastScreenBehavior((ToastScreenBehavior)((Object)value))));
        this.toastAnchorButton = listHelper.addWidget(CycleButton.m_168894_(ToastAnchor::getDisplayName).m_168961_((Object[])ToastAnchor.values()).m_168948_((Object)this.generalConfigData.getToastAnchor()).m_232498_(toastAnchor -> Tooltip.m_257550_((Component)ANCHOR_TOOLTIP)).m_168936_(0, 0, 150, 20, ANCHOR, (button, value) -> this.generalConfigData.setToastAnchor((ToastAnchor)((Object)value))));
        this.offsetXEditBox = listHelper.addWidget(new IntegerEditBox(this.f_96547_, 0, 0, 71, 20, this.offsetXEditBox, (Component)Component.m_237119_(), this.generalConfigData.getOffsetX()));
        this.offsetXEditBox.m_94151_(value -> this.offsetXEditBox.setIntegerValue(this.generalConfigData::setOffsetX));
        this.offsetYEditBox = listHelper.addWidget(new IntegerEditBox(this.f_96547_, 0, 0, 71, 20, this.offsetYEditBox, (Component)Component.m_237119_(), this.generalConfigData.getOffsetY()));
        this.offsetYEditBox.m_94151_(value -> this.offsetYEditBox.setIntegerValue(this.generalConfigData::setOffsetY));
        this.loopsStrengthSlider = listHelper.addWidget(this.createSlider(LOOPS_STRENGTH, this.generalConfigData.getLoopsStrength(), 10.0f, 0.02f, this::multiplierDisplayer, this.generalConfigData::setLoopsStrength, 0, 0, Tooltip.m_257550_((Component)LOOPS_STRENGTH_TOOLTIP)));
        this.loopsSpeedSlider = listHelper.addWidget(this.createSlider(LOOPS_SPEED, this.generalConfigData.getLoopsSpeed(), 10.0f, 0.02f, this::multiplierDisplayer, this.generalConfigData::setLoopsSpeed, 0, 0, Tooltip.m_257550_((Component)LOOPS_SPEED_TOOLTIP)));
        this.taskVolumeSlider = listHelper.addWidget(this.createSlider(TASK_VOLUME, this.generalConfigData.getTaskVolume(), 2.0f, this::percentDisplayer, this.generalConfigData::setTaskVolume, 0, 0));
        this.goalVolumeSlider = listHelper.addWidget(this.createSlider(GOAL_VOLUME, this.generalConfigData.getGoalVolume(), 2.0f, this::percentDisplayer, this.generalConfigData::setGoalVolume, 0, 0));
        this.challengeVolumeSlider = listHelper.addWidget(this.createSlider(CHALLENGE_VOLUME, this.generalConfigData.getChallengeVolume(), 2.0f, this::percentDisplayer, this.generalConfigData::setChallengeVolume, 0, 0));
        listHelper.arrangeWidgets();
        listHelper.visitWidgets(this::addFWidget);
    }

    private void confirmResetting() {
        this.openScreen((Screen)new ConfirmScreen(this::reset, RESET_GENERAL_SETTINGS_TITLE, RESET_GENERAL_SETTINGS_LABEL));
    }

    private void reset(boolean isConfirmed) {
        this.openScreen(this);
        if (!isConfirmed) {
            return;
        }
        this.generalConfigData = new GeneralConfigData();
        this.save(this.generalConfigData.copy());
        this.m_232761_();
    }

    private void done() {
        GeneralConfigData data = this.generalConfigData.copy();
        if (!data.equals(Managers.getConfigManager().getGeneralConfigData())) {
            this.save(data);
        } else {
            this.toParentScreen();
        }
    }

    private void save(GeneralConfigData data) {
        ConfigHandler.save(data);
        Managers.getEventManager().changed(new GeneralConfigDataEvent(data));
        this.isSaved = true;
        this.savedFeedbackStartTime = Util.m_137550_();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.drawBackground(guiGraphics);
        this.drawTitle(guiGraphics);
        this.drawListBackground(guiGraphics);
        this.drawRenderables(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSavedFeedback(guiGraphics, this.f_96543_ / 2 + 8 - 25 + 150, this.f_96544_ - 20);
        this.drawPositionHints(guiGraphics);
    }

    private void drawPositionHints(GuiGraphics guiGraphics) {
        if (this.offsetXEditBox == null || this.offsetYEditBox == null) {
            return;
        }
        int offsetX = 7;
        int offsetY = 5;
        guiGraphics.m_280488_(this.f_96547_, "x:", this.offsetXEditBox.m_252754_() - offsetX, this.offsetXEditBox.m_252907_() + offsetY, -6250336);
        guiGraphics.m_280488_(this.f_96547_, "y:", this.offsetYEditBox.m_252754_() - offsetX, this.offsetYEditBox.m_252907_() + offsetY, -6250336);
    }

    private void drawSavedFeedback(GuiGraphics guiGraphics, int x, int y) {
        if (!this.isSaved) {
            return;
        }
        long time = Util.m_137550_() - this.savedFeedbackStartTime;
        float appearanceLerp = MathEasing.easeOutLerp(0.0f, 1.0f, Appearance.getProgress(time, 500, 0));
        float disappearanceLerp = Appearance.getProgress(time, 500, 400);
        int color = Colors.alpha(appearanceLerp - disappearanceLerp, -256);
        guiGraphics.m_280430_(this.f_96547_, SAVED_LABEL, x, y, color);
        if (time > 850L) {
            this.isSaved = false;
        }
    }

    private void drawListBackground(GuiGraphics guiGraphics) {
        int x0 = 0;
        int x1 = this.f_96543_;
        int y0 = 32;
        int y1 = this.f_96544_ - 32;
        guiGraphics.m_280509_(x0, y0, x1, y1, 0x77000000);
        guiGraphics.m_285978_(RenderType.m_286086_(), x0, y0, x1, y0 + 4, -16777216, 0, 0);
        guiGraphics.m_285978_(RenderType.m_286086_(), x0, y1 - 4, x1, y1, 0, -16777216, 0);
    }

    private Component multiplierDisplayer(float value) {
        return Component.m_237113_((String)("x" + value));
    }

    private Component percentDisplayer(float value) {
        return Component.m_237113_((String)(Math.round(value * 100.0f) + "%"));
    }

    private static class ListHelper {
        private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        private final Screen parentScreen;

        private ListHelper(Screen parentScreen) {
            this.parentScreen = parentScreen;
        }

        public <T extends AbstractWidget> T addWidget(T widget) {
            this.widgets.add(widget);
            return widget;
        }

        public void arrangeWidgets() {
            int y = 40;
            int xCenter = this.parentScreen.f_96543_ / 2;
            int neighbours = 0;
            int numMinus = 0;
            for (int i = 0; i < this.widgets.size(); ++i) {
                AbstractWidget widget = this.widgets.get(i);
                int x = xCenter;
                if (widget.m_5711_() != 150) {
                    ++neighbours;
                }
                if (neighbours == 2) {
                    x += 79;
                    --i;
                }
                if (((i -= numMinus) & 1) == 0) {
                    if (i != 0 && neighbours != 2) {
                        y += 28;
                    }
                    x -= 154;
                } else {
                    x += 4;
                }
                i += numMinus;
                if (neighbours == 2) {
                    ++i;
                    ++numMinus;
                    neighbours = 0;
                }
                widget.m_264152_(x, y);
            }
        }

        public void visitWidgets(Consumer<AbstractWidget> widgetConsumer) {
            this.widgets.forEach(widgetConsumer);
        }
    }
}

