/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class Slider
extends AbstractSliderButton {
    private final Component label;
    private final double min;
    private final double max;
    private final float threshold;
    private boolean isPressed;
    private Function<Float, Component> displayer;
    private Consumer<Float> responder;

    public Slider(int x, int y, int width, int height, Component label, float value, float min, float max, float threshold) {
        super(x, y, width, height, (Component)Component.m_237119_(), (double)(value / max));
        this.label = label;
        this.min = min;
        this.max = max;
        this.threshold = threshold;
        this.m_5695_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clicked = super.m_6375_(mouseX, mouseY, button);
        if (clicked) {
            this.isPressed = true;
        }
        return clicked;
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (this.isPressed) {
            this.playSound(Minecraft.m_91087_().m_91106_());
        }
        this.isPressed = false;
    }

    private void playSound(SoundManager soundManager) {
        soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public Slider(int x, int y, int width, int height, Component label, float value, float max, float threshold) {
        this(x, y, width, height, label, value, 0.0f, max, threshold);
    }

    public Slider setResponder(Consumer<Float> responder) {
        this.responder = responder;
        return this;
    }

    public Slider setDisplayer(Function<Float, Component> displayer) {
        this.displayer = displayer;
        this.m_5695_();
        return this;
    }

    private float getValue() {
        float value = (float)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.min, (double)this.max) * 100.0) / 100.0f;
        int intValue = Math.round(value);
        if (this.threshold != 0.0f && value >= (float)intValue - this.threshold && value <= (float)intValue + this.threshold) {
            return intValue;
        }
        return value;
    }

    protected void m_5695_() {
        if (this.displayer == null) {
            this.displayer = value -> Component.m_237113_((String)value.toString());
        }
        this.m_93666_((Component)CommonComponents.m_178393_((Component)this.label, (Component)this.displayer.apply(Float.valueOf(this.getValue()))));
    }

    protected void m_5697_() {
        if (this.responder == null) {
            return;
        }
        this.responder.accept(Float.valueOf(this.getValue()));
    }
}

