/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import net.bivrik.fancytoasts.client.gui.screen.ToastConfigScreen;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SettingType {
    TEXTURES("textures"){

        @Override
        public void apply(ToastConfigScreen instance, ResourceLocation id) {
            instance.getConfigData().setTextureId(id);
        }

        @Override
        public DisplayData getDisplayData(ResourceLocation id) {
            return TextureRegistry.getData(id);
        }

        @Override
        public ResourceLocation getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getTextureId();
        }

        @Override
        public ResourceLocation[] getKeySet() {
            return TextureRegistry.getIds().toArray(new ResourceLocation[0]);
        }
    }
    ,
    ANIMATIONS("animations"){

        @Override
        public void apply(ToastConfigScreen instance, ResourceLocation id) {
            instance.getConfigData().setAnimationId(id);
        }

        @Override
        public DisplayData getDisplayData(ResourceLocation id) {
            return AnimationRegistry.getData(id);
        }

        @Override
        public ResourceLocation getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getAnimationId();
        }

        @Override
        public ResourceLocation[] getKeySet() {
            return AnimationRegistry.getIds().toArray(new ResourceLocation[0]);
        }
    }
    ,
    SOUNDS("sounds"){

        @Override
        public void apply(ToastConfigScreen instance, ResourceLocation id) {
            instance.getConfigData().putSoundIdForType(id, instance.getAdvancementType());
        }

        @Override
        public DisplayData getDisplayData(ResourceLocation id) {
            String name = id.m_214298_();
            DisplayData data = id.m_135827_().equals("minecraft") ? new DisplayData(name, "Minecraft", Components.stringOf("toast.sound.minecraft.description"), false) : (BuiltInRegistries.f_256894_.m_7804_(id) ? new DisplayData(name, id.m_135827_(), Components.stringOf("toast.sound.mod.description"), false) : new DisplayData(name, id.m_135827_(), Components.stringOf("toast.sound.resourcepack.description"), false));
            return data;
        }

        @Override
        public ResourceLocation getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getSoundIdByType(instance.getAdvancementType());
        }

        @Override
        public ResourceLocation[] getKeySet() {
            return Minecraft.m_91087_().m_91106_().m_120354_().toArray(new ResourceLocation[0]);
        }
    };

    private final String name;

    public abstract void apply(ToastConfigScreen var1, ResourceLocation var2);

    public abstract DisplayData getDisplayData(ResourceLocation var1);

    public abstract ResourceLocation getCurrentId(ToastConfigScreen var1);

    public abstract ResourceLocation[] getKeySet();

    private SettingType(String name) {
        this.name = name;
    }

    public Component getDisplayName() {
        return Components.of("gui." + this.name);
    }

    public String getName() {
        return this.name;
    }
}

