/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tinyallies.entity.Creepy;
import net.tinyallies.entity.EnderBoy;
import net.tinyallies.entity.ModEntities;

public class ModUtil {
    private static final Map<EntityType<? extends PathfinderMob>, EntityType<? extends PathfinderMob>> babyficationList = Map.ofEntries(Map.entry(EntityType.f_20558_, (EntityType)ModEntities.CREEPY.get()), Map.entry(EntityType.f_20524_, (EntityType)ModEntities.SKELLY.get()), Map.entry(EntityType.f_20566_, (EntityType)ModEntities.ENDERBOY.get()), Map.entry(EntityType.f_20479_, (EntityType)ModEntities.SPIDEY.get()), Map.entry(EntityType.f_20501_, (EntityType)ModEntities.ZOMBY.get()));

    public static Mob babifyMob(Mob mob) {
        EntityType type = mob.m_6095_();
        Mob baby = null;
        if (babyficationList.containsKey(type)) {
            baby = mob.m_21406_(babyficationList.get(mob.m_6095_()), true);
            baby.m_21153_(mob.m_21223_());
            if (type.equals(EntityType.f_20558_)) {
                ((Creepy)baby).setPowered(((Creeper)mob).m_7090_());
                ((Creepy)baby).m_32283_(((Creeper)mob).m_32310_());
            } else if (type.equals(EntityType.f_20566_)) {
                ((EnderBoy)baby).m_32521_(((EnderMan)mob).m_32530_());
                baby.m_6710_(mob.m_5448_());
            } else if (type.equals(ModEntities.SKELLY.get()) && baby.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                baby.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
            }
        } else {
            mob.m_6863_(true);
        }
        return baby;
    }

    public static InteractionResult spawnBabyFromEgg(Mob mob, ItemStack itemStack, EntityType<?> type) {
        ItemStack pickResult = mob.m_142340_();
        Level level = mob.m_9236_();
        if (!level.f_46443_ && pickResult != null && itemStack.m_150930_(pickResult.m_41720_())) {
            Mob baby = (Mob)type.m_20615_(level);
            baby.m_146884_(mob.m_20182_());
            if (type.equals(ModEntities.SKELLY.get())) {
                baby.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
            }
            level.m_7967_((Entity)baby);
            return InteractionResult.m_19078_((boolean)true);
        }
        return InteractionResult.PASS;
    }

    public static void babyfyModel(Iterable<ModelPart> headParts, Iterable<ModelPart> bodyParts, float headY, float headZ, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.75f, 0.75f, 0.75f);
        pPoseStack.m_252880_(0.0f, headY / 16.0f, headZ / 16.0f);
        headParts.forEach(modelPart -> modelPart.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        pPoseStack.m_252880_(0.0f, 1.5f, 0.0f);
        bodyParts.forEach(modelPart -> modelPart.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
        pPoseStack.m_85849_();
    }
}

