/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.tinyallies.entity.BabyMonster;
import net.tinyallies.entity.EnderBoy;

public class FollowOwnerGoal
extends Goal {
    private final PathfinderMob mob;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private final float stopDistance;
    private final float startDistance;
    private final boolean canFly;
    private BabyMonster baby;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public FollowOwnerGoal(PathfinderMob pTamable, double pSpeedModifier, float pStartDistance, float pStopDistance, boolean pCanFly) {
        PathfinderMob pathfinderMob = this.mob = pTamable;
        if (pathfinderMob instanceof BabyMonster) {
            BabyMonster baby;
            this.baby = baby = (BabyMonster)pathfinderMob;
        }
        this.level = pTamable.m_9236_();
        this.speedModifier = pSpeedModifier;
        this.navigation = pTamable.m_21573_();
        this.startDistance = pStartDistance;
        this.stopDistance = pStopDistance;
        this.canFly = pCanFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity owner1 = this.baby.getOwner();
        if (owner1 == null) {
            return false;
        }
        if (owner1.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.baby.isUndead()) {
            LivingEntity lastHurtByMob = owner1.m_21188_();
            if (lastHurtByMob != null && lastHurtByMob.m_21214_() == owner1 && lastHurtByMob.m_21231_().m_19295_() > 0) {
                return false;
            }
            LivingEntity lastHurtMob = owner1.m_21214_();
            if (lastHurtMob != null && (lastHurtMob.m_6084_() || lastHurtMob.m_20280_((Entity)owner1) > 14.0)) {
                return false;
            }
        }
        this.owner = owner1;
        return this.mob.m_20280_((Entity)owner1) >= (double)(this.startDistance * this.startDistance) || !this.mob.m_142582_((Entity)this.owner);
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return this.mob.m_20280_((Entity)this.owner) > (double)(this.stopDistance * this.stopDistance);
    }

    private boolean unableToMove() {
        return this.baby.isOrderedToSit() || this.mob.m_20159_() || this.mob.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(40);
            if (this.mob.m_20280_((Entity)this.owner) >= 180.0) {
                this.teleportToOwner();
                return;
            }
            if (this.mob instanceof EnderBoy && this.mob.m_9236_().m_46471_()) {
                return;
            }
            if (this.baby.isUndead()) {
                ItemStack helmet = this.mob.m_6844_(EquipmentSlot.HEAD);
                if (helmet.m_41619_() && this.mob.m_9236_().m_46461_()) {
                    return;
                }
                if (!helmet.m_41619_() && helmet.m_41776_() - helmet.m_41773_() <= helmet.m_41776_() / 3) {
                    return;
                }
                LivingEntity lastHurtByMob = this.owner.m_21188_();
                if (lastHurtByMob != null && lastHurtByMob.m_21214_() == this.owner && lastHurtByMob.m_21231_().m_19295_() > 0) {
                    return;
                }
                LivingEntity lastHurtMob = this.owner.m_21214_();
                if (lastHurtMob != null && (lastHurtMob.m_6084_() || lastHurtMob.m_20280_((Entity)this.owner) > 14.0)) {
                    return;
                }
            }
            this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.m_20185_()) < 2.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.mob.m_7678_((double)pX + 0.5, (double)pY, (double)pZ + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        BlockState blockstate = this.level.m_8055_(pPos.m_7495_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        if (this.mob instanceof EnderBoy && this.mob.m_9236_().m_46758_(pPos)) {
            return false;
        }
        if (this.baby.isUndead()) {
            ItemStack helmet = this.mob.m_6844_(EquipmentSlot.HEAD);
            if (helmet.m_41619_() && this.mob.m_9236_().m_46461_()) {
                return false;
            }
            if (!helmet.m_41619_() && helmet.m_41776_() - helmet.m_41773_() <= helmet.m_41776_() / 3) {
                return false;
            }
            LivingEntity lastHurtByMob = this.owner.m_21188_();
            if (lastHurtByMob != null && lastHurtByMob.m_21214_() == this.owner && lastHurtByMob.m_21231_().m_19295_() > 0) {
                return false;
            }
            LivingEntity lastHurtMob = this.owner.m_21214_();
            if (lastHurtMob != null && (lastHurtMob.m_6084_() || lastHurtMob.m_20280_((Entity)this.owner) > 14.0)) {
                return false;
            }
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)this.mob.m_20183_());
        return this.level.m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.mob.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

