/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import net.tinyallies.entity.BabyMonster;
import net.tinyallies.entity.ai.LookForParentGoal;
import org.jetbrains.annotations.Nullable;

public class Spidey
extends Spider
implements NeutralMob,
BabyMonster {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Spidey.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(Spidey.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static EntityDimensions STANDING = EntityDimensions.m_20395_((float)0.9f, (float)0.45f);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING).put((Object)Pose.SITTING, (Object)EntityDimensions.m_20395_((float)0.9f, (float)0.35f)).build();
    private final AvoidEntityGoal<Player> avoidPlayersGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 0.8, 1.33);
    private final LookForParentGoal followParentGoal = new LookForParentGoal((Mob)this, 1.0, this.getParentClass());
    private final NearestAttackableTargetGoal<Player> targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    private boolean orderedToSit;
    private LivingEntity parent;

    public Spidey(EntityType<? extends Spider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.reassessTameGoals();
        this.applyAttributeModifiers();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BabySpiderLeapAtTargetGoal(this, 0.4f));
        this.f_21345_.m_25352_(0, (Goal)new BabySpiderAttackGoal(this));
        this.defaultBabyGoals((PathfinderMob)this);
    }

    @Override
    public void reassessTameGoals() {
        this.f_21345_.m_25363_((Goal)this.followParentGoal);
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        this.f_21345_.m_25363_(this.targetPlayerGoal);
        if (!this.isTamed()) {
            if (this.getParent() == null) {
                this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
            } else {
                this.f_21345_.m_25352_(0, (Goal)this.followParentGoal);
                this.f_21346_.m_25352_(3, this.targetPlayerGoal);
            }
        }
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return POSES.getOrDefault(pPose, STANDING);
    }

    public boolean m_6673_(DamageSource pSource) {
        return this.hasSameOwner(pSource.m_7639_()) || super.m_6673_(pSource);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Items.f_42645_);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return pPose == Pose.SITTING ? 0.29f : 0.34f;
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.m_41720_().m_41473_().m_38746_();
    }

    @Override
    public LivingEntity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LivingEntity living) {
        this.parent = living;
    }

    @Override
    public Class<? extends PathfinderMob> getParentClass() {
        return Spider.class;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return this.babyHurt((LivingEntity)this, pSource, super.m_6469_(pSource, pAmount));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return this.babyInteract(pPlayer, pHand, super.m_6071_(pPlayer, pHand));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addBabySaveData(pCompound, this.orderedToSit);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readBabySaveData(pCompound, (LivingEntity)this);
        this.orderedToSit = pCompound.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_() && pPlayer == this.getOwner();
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        this.handleBabyEvent(pId);
    }

    public void setDataFlagsId(boolean pTamed, byte mask) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pTamed ? (byte)(flagsID | mask) : (byte)(flagsID & ~mask)));
    }

    public void m_8119_() {
        if (this.getParent() != null && !this.getParent().m_6084_()) {
            this.setParent(null);
            this.reassessTameGoals();
        }
        this.updatePose((LivingEntity)this);
        super.m_8119_();
    }

    protected void m_6119_() {
        if (this.m_21524_() != null && this.isInSittingPose()) {
            if (this.m_20270_(this.m_21524_()) > 10.0f) {
                this.m_21455_(true, true);
            }
            return;
        }
        super.m_6119_();
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int pRemainingPersistentAngerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return !this.hasSameOwner((Entity)livingEntity) && super.m_6779_(livingEntity);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    public Team m_5647_() {
        return this.getBabyTeam(super.m_5647_());
    }

    public boolean m_7307_(Entity pEntity) {
        return this.babyIsAlliedTo(pEntity, super.m_7307_(pEntity));
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (this.f_20890_) {
            this.sendDeathMessage((PathfinderMob)this);
        }
    }

    public boolean m_6935_(Player pPlayer) {
        return !this.isTamed();
    }

    @Override
    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    @Override
    public void setOrderedToSit(boolean pOrderedToSit) {
        this.orderedToSit = pOrderedToSit;
    }

    @Override
    public boolean isTamed() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    @Override
    public void setTamed(boolean pTamed) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pTamed ? (byte)(flagsID | 4) : (byte)(flagsID & 0xFFFFFFFF)));
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    public void setInSittingPose(boolean pSitting) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pSitting ? (byte)(flagsID | 1) : (byte)(flagsID & 0xFFFFFFFE)));
    }

    static class BabySpiderLeapAtTargetGoal
    extends LeapAtTargetGoal {
        private final Spidey spidey;

        public BabySpiderLeapAtTargetGoal(Spidey pSpidey, float pYd) {
            super((Mob)pSpidey, pYd);
            this.spidey = pSpidey;
        }

        public boolean m_8045_() {
            return !this.spidey.isOrderedToSit() && super.m_8045_();
        }
    }

    static class BabySpiderAttackGoal
    extends MeleeAttackGoal {
        private final Spidey spidey;

        public BabySpiderAttackGoal(Spidey pSpider) {
            super((PathfinderMob)pSpider, 1.0, true);
            this.spidey = pSpider;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return !this.spidey.isOrderedToSit() && super.m_8045_();
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return 4.0f + pAttackTarget.m_20205_();
        }
    }
}

