/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import net.tinyallies.entity.BabyMonster;
import net.tinyallies.entity.ai.LookForParentGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Skelly
extends Skeleton
implements NeutralMob,
BabyMonster {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Skelly.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(Skelly.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static EntityDimensions STANDING = EntityDimensions.m_20395_((float)0.33f, (float)1.05f);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING).put((Object)Pose.SITTING, (Object)EntityDimensions.m_20395_((float)0.33f, (float)0.75f)).build();
    private final AvoidEntityGoal<Player> avoidPlayersGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 0.8, 1.33);
    private final LookForParentGoal followParentGoal = new LookForParentGoal((Mob)this, 1.0, this.getParentClass());
    private final NearestAttackableTargetGoal<Player> targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    private boolean orderedToSit;
    private LivingEntity parent;

    public Skelly(EntityType<? extends Skelly> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.reassessTameGoals();
        this.applyAttributeModifiers();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.0));
        this.defaultBabyGoals((PathfinderMob)this);
    }

    @Override
    public void reassessTameGoals() {
        this.f_21345_.m_25363_((Goal)this.followParentGoal);
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        this.f_21345_.m_25363_(this.targetPlayerGoal);
        if (!this.isTamed()) {
            if (this.getParent() == null) {
                this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
            } else {
                this.f_21345_.m_25352_(0, (Goal)this.followParentGoal);
                this.f_21346_.m_25352_(3, this.targetPlayerGoal);
            }
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        return this.hasSameOwner(pSource.m_7639_()) || super.m_6673_(pSource);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Items.f_42642_);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return pPose == Pose.SITTING ? 0.58f : 0.93f;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return POSES.getOrDefault(pPose, STANDING);
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.m_150930_(Items.f_42499_);
    }

    @Override
    public Class<? extends PathfinderMob> getParentClass() {
        return Skeleton.class;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return this.babyHurt((LivingEntity)this, pSource, super.m_6469_(pSource, pAmount));
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (!this.m_9236_().f_46443_ && this.isOwnedBy((Entity)pPlayer) && this.isTamed() && pPlayer.m_6047_()) {
            if (item instanceof ArmorItem || item instanceof BowItem) {
                EquipmentSlot slot = Skelly.m_147233_((ItemStack)itemstack);
                if (!this.m_6844_(slot).m_41619_()) {
                    this.m_19983_(this.m_6844_(slot));
                }
                this.m_21468_(slot, itemstack.m_41777_());
                if (!pPlayer.m_150110_().f_35937_) {
                    pPlayer.m_150109_().m_36057_(itemstack);
                }
                this.m_216990_(slot.m_254934_() ? SoundEvents.f_11675_ : SoundEvents.f_12013_);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_()) {
                this.m_20158_().forEach(stack -> {
                    this.m_19983_((ItemStack)stack);
                    this.m_8061_(Skelly.m_147233_((ItemStack)stack), ItemStack.f_41583_);
                });
                return InteractionResult.SUCCESS;
            }
        }
        return this.babyInteract(pPlayer, pHand, super.m_6071_(pPlayer, pHand));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addBabySaveData(pCompound, this.orderedToSit);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readBabySaveData(pCompound, (LivingEntity)this);
        this.orderedToSit = pCompound.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_() && pPlayer == this.getOwner();
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        this.handleBabyEvent(pId);
    }

    @Override
    public LivingEntity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LivingEntity living) {
        this.parent = living;
    }

    public void m_8119_() {
        if (this.getParent() != null && !this.getParent().m_6084_()) {
            this.setParent(null);
            this.reassessTameGoals();
        }
        this.updatePose((LivingEntity)this);
        super.m_8119_();
    }

    protected void m_6119_() {
        if (this.m_21524_() != null && this.isInSittingPose()) {
            if (this.m_20270_(this.m_21524_()) > 10.0f) {
                this.m_21455_(true, true);
            }
            return;
        }
        super.m_6119_();
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return !this.hasSameOwner((Entity)livingEntity) && super.m_6779_(livingEntity);
    }

    public Team m_5647_() {
        return this.getBabyTeam(super.m_5647_());
    }

    public boolean m_7307_(Entity pEntity) {
        return this.babyIsAlliedTo(pEntity, super.m_7307_(pEntity));
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (this.f_20890_) {
            this.sendDeathMessage((PathfinderMob)this);
        }
    }

    public boolean m_6935_(Player pPlayer) {
        return !this.isTamed();
    }

    @Override
    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    @Override
    public void setOrderedToSit(boolean pOrderedToSit) {
        this.orderedToSit = pOrderedToSit;
    }

    public double m_6049_() {
        return this.m_6162_() ? -0.6 : -0.45;
    }

    @Override
    public boolean isUndead() {
        return true;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int pRemainingPersistentAngerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
    }

    public void m_6825_() {
    }

    @Override
    public boolean isTamed() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    @Override
    public void setTamed(boolean pTamed) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pTamed ? (byte)(flagsID | 4) : (byte)(flagsID & 0xFFFFFFFF)));
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(pUuid));
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    public void setInSittingPose(boolean pSitting) {
        byte flagsID = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)(pSitting ? (byte)(flagsID | 1) : (byte)(flagsID & 0xFFFFFFFE)));
    }
}

