/*
 * Decompiled with CFR 0.152.
 */
package net.tinyallies.entity;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.tinyallies.TinyAlliesCommon;
import net.tinyallies.entity.Creepy;
import net.tinyallies.entity.EnderBoy;
import net.tinyallies.entity.Skelly;
import net.tinyallies.entity.Spidey;
import net.tinyallies.entity.Zomby;
import net.tinyallies.entity.projectile.BabyfierBlob;
import net.tinyallies.util.TinyAlliesResLoc;

public class ModEntities {
    private static final Registrar<EntityType<?>> ENTITY_TYPES = TinyAlliesCommon.REGISTRIES.get(Registries.f_256939_);
    public static final RegistrySupplier<EntityType<Creepy>> CREEPY = ModEntities.registerBaby("creeper", Creepy::new, MobCategory.MONSTER, 0.33f, 0.85f);
    public static final RegistrySupplier<EntityType<Skelly>> SKELLY = ModEntities.registerBaby("skeleton", Skelly::new, MobCategory.MONSTER, 0.33f, 1.05f);
    public static final RegistrySupplier<EntityType<EnderBoy>> ENDERBOY = ModEntities.registerBaby("enderman", EnderBoy::new, MobCategory.MONSTER, 0.33f, 1.4f);
    public static final RegistrySupplier<EntityType<Spidey>> SPIDEY = ModEntities.registerBaby("spider", Spidey::new, MobCategory.MONSTER, 0.9f, 0.45f);
    public static final RegistrySupplier<EntityType<Zomby>> ZOMBY = ModEntities.registerBaby("zombie", Zomby::new, MobCategory.MONSTER, 0.33f, 1.05f);
    public static final RegistrySupplier<EntityType<BabyfierBlob>> BLOB = ModEntities.create("blob", () -> EntityType.Builder.m_20704_(BabyfierBlob::new, (MobCategory)MobCategory.MISC).m_20702_(4).m_20717_(20).m_20699_(0.1f, 0.1f).m_20712_("blob"));

    public static <T extends Entity> RegistrySupplier<EntityType<T>> registerBaby(String name, EntityType.EntityFactory<T> pFactory, MobCategory pCategory, float width, float height) {
        return ModEntities.create(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)pFactory, (MobCategory)pCategory).m_20699_(width, height).m_20712_(name));
    }

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new TinyAlliesResLoc(path), type);
    }

    public static void register() {
        EntityAttributeRegistry.register(CREEPY, Creeper::m_32318_);
        EntityAttributeRegistry.register(SKELLY, AbstractSkeleton::m_32166_);
        EntityAttributeRegistry.register(ENDERBOY, EnderMan::m_32541_);
        EntityAttributeRegistry.register(SPIDEY, Spider::m_33815_);
        EntityAttributeRegistry.register(ZOMBY, Zombie::m_34328_);
    }
}

